/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio.bias;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedFile;
import org.lsst.fits.imageio.Segment;
import org.lsst.fits.imageio.bias.BiasCorrection;

public class SerialParallelBiasSub
implements BiasCorrection {
    private final int targetBiasLevel = 20000;

    @Override
    public BiasCorrection.CorrectionFactors compute(IntBuffer data, Segment segment) {
        int nAxis1 = segment.getNAxis1();
        int nAxis2 = segment.getNAxis2();
        Rectangle datasec = segment.getDataSec();
        int averageSerialBias = 0;
        int serialOverscanStart = datasec.x + datasec.width + 4;
        int position = 0;
        for (int y = datasec.y; y < datasec.height + datasec.y; ++y) {
            int biasSum = 0;
            for (int x = serialOverscanStart; x < nAxis1; ++x) {
                biasSum += data.get(position + x);
            }
            averageSerialBias += (biasSum /= nAxis1 - serialOverscanStart);
            position += nAxis1;
        }
        int averageParallelBias = 0;
        int parallelOverscanStart = datasec.y + datasec.height + 4;
        int prevBiasSum = 22000;
        for (int x = datasec.x; x < datasec.width + datasec.x; ++x) {
            int biasSum = 0;
            for (int y = parallelOverscanStart; y < nAxis2; ++y) {
                biasSum += data.get(x + y * nAxis1);
            }
            if ((biasSum /= nAxis2 - parallelOverscanStart) > 100000) {
                biasSum = prevBiasSum;
            }
            averageParallelBias += biasSum;
            position += nAxis1;
            prevBiasSum = biasSum;
        }
        int overallCorrection = 20000 - (averageSerialBias + averageParallelBias) / (datasec.width + datasec.height);
        SimpleCorrectionFactors simpleCorrectionFactors = new SimpleCorrectionFactors(datasec, overallCorrection);
        return simpleCorrectionFactors;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return SerialParallelBiasSub.class.hashCode();
    }

    public static void main(String[] args) throws IOException, TruncatedFileException, FitsException {
        File file = new File("/home/tonyj/Data/pretty/20_Flat_screen_0000_20190322172301.fits");
        BufferedFile bf = new BufferedFile(file, "r");
        Header header = new Header((ArrayDataInput)bf);
        for (int i = 0; i < 11; ++i) {
            header = new Header((ArrayDataInput)bf);
            bf.seek(bf.getFilePointer() + header.getDataSize());
        }
        header = new Header((ArrayDataInput)bf);
        Segment segment = new Segment(header, file, bf, "R22", "S20", '4', null);
        IntBuffer intBuffer = (IntBuffer)segment.readRawDataAsync(null).join().getBuffer();
        SerialParallelBiasSub bc = new SerialParallelBiasSub();
        BiasCorrection.CorrectionFactors factors = bc.compute(intBuffer, segment);
        System.out.println(factors);
    }

    void streamSerialOverscan(IntBuffer data, Segment segment, int rowsToSkip, Callback callback) {
        Rectangle datasec = segment.getDataSec();
        int nAxis1 = segment.getNAxis1();
        int serialOverscanStart = datasec.x + datasec.width + rowsToSkip;
        int position = 0;
        for (int y = datasec.y; y < datasec.height + datasec.y; ++y) {
            for (int x = serialOverscanStart; x < nAxis1; ++x) {
                callback.apply(x, y, data.get(position + x));
            }
            position += nAxis1;
        }
    }

    void streamParallelOverscan(IntBuffer data, Segment segment, int colsToSkip, Callback callback) {
        Rectangle datasec = segment.getDataSec();
        int nAxis1 = segment.getNAxis1();
        int nAxis2 = segment.getNAxis2();
        int parallelOverscanStart = datasec.y + datasec.height + colsToSkip;
        for (int x = datasec.x; x < datasec.width + datasec.x; ++x) {
            for (int y = parallelOverscanStart; y < nAxis2; ++y) {
                callback.apply(x, y, data.get(x + y * nAxis1));
            }
        }
    }

    public static class SimpleCorrectionFactors
    implements BiasCorrection.CorrectionFactors {
        private final Rectangle datasec;
        private final int overallCorrection;

        private SimpleCorrectionFactors(Rectangle datasec, int overallCorrection) {
            this.datasec = datasec;
            this.overallCorrection = overallCorrection;
        }

        @Override
        public int correctionFactor(int x, int y) {
            return -this.overallCorrection;
        }

        public String toString() {
            return "SimpleCorrectionFactors{datasec=" + this.datasec + ", overallCorrection=" + this.overallCorrection + "}";
        }
    }

    private static interface Callback {
        public void apply(int var1, int var2, int var3);
    }
}

