/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.compression.algorithm.api.ICompressor;
import nom.tam.fits.compression.algorithm.gzip2.GZip2Compressor;
import nom.tam.fits.compression.algorithm.rice.RiceCompressOption;
import nom.tam.fits.compression.algorithm.rice.RiceCompressor;
import nom.tam.fits.header.Standard;
import nom.tam.util.BufferedFile;
import org.lsst.fits.imageio.RawData;

public class Segment {
    private static final Pattern DATASET_PATTERN = Pattern.compile("\\[(\\d+):(\\d+),(\\d+):(\\d+)\\]");
    private final File file;
    private final long seekPosition;
    private final Rectangle2D.Double wcs;
    private final AffineTransform wcsTranslation;
    private Rectangle datasec;
    private final int nAxis1;
    private final int nAxis2;
    private double crval1;
    private double crval2;
    private double pc1_1;
    private double pc2_2;
    private double pc1_2;
    private double pc2_1;
    private final char wcsLetter;
    private final int rawDataLength;
    private final boolean isCompressed;
    private int channel;
    private final int cAxis1;
    private final int cAxis2;
    private final int zTile1;
    private final int zTile2;
    private final String segmentName;
    private final String raftBay;
    private final String ccdSlot;
    private final String compressionType;
    private final int bitpix;

    public Segment(Header header, File file, BufferedFile bf, String raftBay, String ccdSlot, char wcsLetter, Map<String, Object> wcsOverride) throws IOException, FitsException {
        this.file = file;
        this.seekPosition = bf.getFilePointer();
        this.wcsLetter = wcsLetter;
        this.raftBay = raftBay;
        this.ccdSlot = ccdSlot;
        this.isCompressed = header.getBooleanValue("ZIMAGE");
        this.segmentName = header.getStringValue("EXTNAME");
        if (this.isCompressed) {
            this.bitpix = header.getIntValue("ZBITPIX");
            this.compressionType = header.getStringValue("ZCMPTYPE");
            if (!"RICE_1".equals(this.compressionType) && !"GZIP_2".equals(header.getStringValue("ZCMPTYPE"))) {
                throw new FitsException("Unsupported compression type: " + this.compressionType);
            }
            this.nAxis1 = header.getIntValue("ZNAXIS1");
            this.nAxis2 = header.getIntValue("ZNAXIS2");
            this.rawDataLength = header.getIntValue(Standard.NAXIS1) * header.getIntValue(Standard.NAXIS2) + header.getIntValue("PCOUNT");
            this.cAxis1 = header.getIntValue(Standard.NAXIS1);
            this.cAxis2 = header.getIntValue(Standard.NAXIS2);
            this.zTile1 = header.getIntValue("ZTILE1");
            this.zTile2 = header.getIntValue("ZTILE2");
        } else {
            this.bitpix = header.getIntValue("BITPIX");
            this.nAxis1 = header.getIntValue(Standard.NAXIS1);
            this.nAxis2 = header.getIntValue(Standard.NAXIS2);
            this.rawDataLength = this.nAxis1 * this.nAxis2 * 4;
            this.zTile2 = 0;
            this.zTile1 = 0;
            this.cAxis2 = 0;
            this.cAxis1 = 0;
            this.compressionType = null;
        }
        int pad = FitsUtil.padding((int)this.rawDataLength);
        bf.skip((long)(this.rawDataLength + pad));
        if (wcsOverride != null) {
            datasecString = wcsOverride.get("DATASEC").toString();
            this.datasec = this.computeDatasec(datasecString);
            this.pc1_1 = ((Number)wcsOverride.get("PC1_1" + wcsLetter)).doubleValue();
            this.pc2_2 = ((Number)wcsOverride.get("PC2_2" + wcsLetter)).doubleValue();
            this.pc1_2 = ((Number)wcsOverride.get("PC1_2" + wcsLetter)).doubleValue();
            this.pc2_1 = ((Number)wcsOverride.get("PC2_1" + wcsLetter)).doubleValue();
            this.crval1 = ((Number)wcsOverride.get("CRVAL1" + wcsLetter)).doubleValue();
            this.crval2 = ((Number)wcsOverride.get("CRVAL2" + wcsLetter)).doubleValue();
            this.channel = header.getIntValue("CHANNEL");
        } else {
            datasecString = header.getStringValue("DATASEC");
            if (datasecString == null) {
                throw new IOException("Missing datasec for file: " + file);
            }
            this.datasec = this.computeDatasec(datasecString);
            this.pc1_1 = header.getDoubleValue("PC1_1" + wcsLetter);
            this.pc2_2 = header.getDoubleValue("PC2_2" + wcsLetter);
            this.pc1_2 = header.getDoubleValue("PC1_2" + wcsLetter);
            this.pc2_1 = header.getDoubleValue("PC2_1" + wcsLetter);
            this.crval1 = header.getDoubleValue("CRVAL1" + wcsLetter);
            this.crval2 = header.getDoubleValue("CRVAL2" + wcsLetter);
            this.channel = header.getIntValue("CHANNEL");
        }
        this.wcsTranslation = new AffineTransform(this.pc1_1, this.pc2_1, this.pc1_2, this.pc2_2, this.crval1, this.crval2);
        this.wcsTranslation.translate((double)this.datasec.x + 0.5, (double)this.datasec.y + 0.5);
        Point2D origin = this.wcsTranslation.transform(new Point(0, 0), null);
        Point2D corner = this.wcsTranslation.transform(new Point(this.datasec.width, this.datasec.height), null);
        double x = Math.min(origin.getX(), corner.getX());
        double y = Math.min(origin.getY(), corner.getY());
        double width = Math.abs(origin.getX() - corner.getX());
        double height = Math.abs(origin.getY() - corner.getY());
        this.wcs = new Rectangle2D.Double(x, y, width, height);
    }

    private Rectangle computeDatasec(String datasecString) throws IOException, NumberFormatException {
        Matcher matcher = DATASET_PATTERN.matcher(datasecString);
        if (!matcher.matches()) {
            throw new IOException("Invalid datasec: " + datasecString);
        }
        int datasec1 = Integer.parseInt(matcher.group(1)) - 1;
        int datasec2 = Integer.parseInt(matcher.group(2));
        int datasec3 = Integer.parseInt(matcher.group(3)) - 1;
        int datasec4 = Integer.parseInt(matcher.group(4));
        return new Rectangle(datasec1, datasec3, datasec2 - datasec1, datasec4 - datasec3);
    }

    public int getImageSize() {
        return this.nAxis1 * this.nAxis2 * 4;
    }

    public int getDataSize() {
        return this.rawDataLength;
    }

    public File getFile() {
        return this.file;
    }

    private IntBuffer decodeGZIP2CompressedData(ByteBuffer bb) {
        return this.decodeCompressedData(bb, (ICompressor<IntBuffer>)new GZip2Compressor.IntGZip2Compressor());
    }

    private FloatBuffer decodeGZIP2FloatCompressedData(ByteBuffer bb) {
        return this.decodeCompressedFloatData(bb, (ICompressor<FloatBuffer>)new GZip2Compressor.FloatGZip2Compressor());
    }

    private IntBuffer decodeRICECompressedData(ByteBuffer bb) {
        RiceCompressOption riceCompressOption = new RiceCompressOption();
        riceCompressOption.setBlockSize(32);
        riceCompressOption.setBytePix(4);
        RiceCompressor.IntRiceCompressor inflater = new RiceCompressor.IntRiceCompressor(riceCompressOption);
        return this.decodeCompressedData(bb, (ICompressor<IntBuffer>)inflater);
    }

    private IntBuffer decodeCompressedData(ByteBuffer bb, ICompressor<IntBuffer> inflater) {
        IntBuffer result = IntBuffer.allocate(this.nAxis1 * this.nAxis2);
        int[] offsets = new int[this.cAxis1 * this.cAxis2 / 4];
        bb.asIntBuffer().get(offsets);
        bb.position(this.cAxis1 * this.cAxis2);
        for (int i = 0; i < this.cAxis2; ++i) {
            result.limit(result.position() + this.nAxis1);
            bb.limit(bb.position() + offsets[i * 2]);
            inflater.decompress(bb, (Buffer)result.slice());
            result.position(result.position() + this.nAxis1);
        }
        result.flip();
        return result;
    }

    private FloatBuffer decodeCompressedFloatData(ByteBuffer bb, ICompressor<FloatBuffer> inflater) {
        FloatBuffer result = FloatBuffer.allocate(this.nAxis1 * this.nAxis2);
        int[] offsets = new int[this.cAxis1 * this.cAxis2 / 4];
        bb.asIntBuffer().get(offsets);
        bb.position(this.cAxis1 * this.cAxis2);
        for (int i = 0; i < this.cAxis2; ++i) {
            result.limit(result.position() + this.nAxis1);
            bb.limit(bb.position() + offsets[i * 2]);
            inflater.decompress(bb, (Buffer)result.slice());
            result.position(result.position() + this.nAxis1);
        }
        result.flip();
        return result;
    }

    public CompletableFuture<RawData> readRawDataAsync(Executor executor) {
        CompletableFuture<ByteBuffer> futureByteBuffer = this.readByteBufferAsync();
        if (this.isCompressed) {
            if ("GZIP_2".equals(this.compressionType)) {
                switch (this.bitpix) {
                    case 32: {
                        return ((CompletableFuture)futureByteBuffer.thenApply(bb -> this.decodeGZIP2CompressedData((ByteBuffer)bb))).thenApply(ib -> new RawData<IntBuffer>(this, (IntBuffer)ib));
                    }
                    case -32: {
                        return ((CompletableFuture)futureByteBuffer.thenApply(bb -> this.decodeGZIP2FloatCompressedData((ByteBuffer)bb))).thenApply(fb -> new RawData<FloatBuffer>(this, (FloatBuffer)fb));
                    }
                }
                throw new RuntimeException("Unsupported bitpix: " + this.bitpix);
            }
            return ((CompletableFuture)futureByteBuffer.thenApply(bb -> this.decodeRICECompressedData((ByteBuffer)bb))).thenApply(ib -> new RawData<IntBuffer>(this, (IntBuffer)ib));
        }
        return futureByteBuffer.thenApply(bb -> new RawData<IntBuffer>(this, bb.asIntBuffer()));
    }

    private CompletableFuture<ByteBuffer> readByteBufferAsync() {
        CompletableFuture<ByteBuffer> result = new CompletableFuture<ByteBuffer>();
        try {
            final AsynchronousFileChannel asyncChannel = AsynchronousFileChannel.open(this.file.toPath(), StandardOpenOption.READ);
            final ByteBuffer bb = ByteBuffer.allocateDirect(this.rawDataLength);
            bb.order(ByteOrder.BIG_ENDIAN);
            asyncChannel.read(bb, this.seekPosition, result, new CompletionHandler<Integer, CompletableFuture<ByteBuffer>>(){

                @Override
                public void completed(Integer len, CompletableFuture<ByteBuffer> future) {
                    try {
                        asyncChannel.close();
                    }
                    catch (IOException ex) {
                        future.completeExceptionally(ex);
                    }
                    bb.flip();
                    future.complete(bb);
                }

                @Override
                public void failed(Throwable x, CompletableFuture<ByteBuffer> future) {
                    try {
                        asyncChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    future.completeExceptionally(x);
                }
            });
        }
        catch (IOException x) {
            result.completeExceptionally(x);
        }
        return result;
    }

    public int getNAxis1() {
        return this.nAxis1;
    }

    public int getNAxis2() {
        return this.nAxis2;
    }

    public AffineTransform getWCSTranslation(boolean includeOverscan) {
        if (includeOverscan) {
            return this.wcsTranslation;
        }
        return this.wcsTranslation;
    }

    public Rectangle getDataSec() {
        return this.datasec;
    }

    boolean intersects(Rectangle sourceRegion) {
        return this.wcs.intersects(sourceRegion);
    }

    public Rectangle2D.Double getWcs() {
        return this.wcs;
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public String getRaftBay() {
        return this.raftBay;
    }

    public String getCcdSlot() {
        return this.ccdSlot;
    }

    public String toString() {
        return "Segment{file=" + this.file + ", name=" + this.segmentName + ", raftBay=" + this.raftBay + ", ccdSlot=" + this.ccdSlot + "}";
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.file);
        hash = 71 * hash + (int)(this.seekPosition ^ this.seekPosition >>> 32);
        hash = 71 * hash + Objects.hashCode(Character.valueOf(this.wcsLetter));
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Segment other = (Segment)obj;
        if (this.seekPosition != other.seekPosition) {
            return false;
        }
        if (!Objects.equals(Character.valueOf(this.wcsLetter), Character.valueOf(other.wcsLetter))) {
            return false;
        }
        return Objects.equals(this.file, other.file);
    }
}

