/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio;

import java.util.logging.Logger;

public class ScalingUtils<T> {
    private static final Logger LOG = Logger.getLogger(ScalingUtils.class.getName());
    private final int[] counts;
    private int lowestBin;
    private int highestBin;

    public ScalingUtils(int[] counts) {
        this.counts = counts;
        this.computeMinMax();
    }

    ScalingUtils(long[] longCounts) {
        int i;
        this.counts = new int[longCounts.length];
        for (i = 0; i < longCounts.length; ++i) {
            this.counts[i] = (int)(longCounts[i] / 100L);
        }
        for (i = 0; i < longCounts.length; ++i) {
            if (longCounts[i] <= 0L) continue;
            this.lowestBin = i;
            break;
        }
        for (i = longCounts.length - 1; i >= 0; --i) {
            if (longCounts[i] <= 0L) continue;
            this.highestBin = i;
            break;
        }
    }

    private void computeMinMax() {
        int i;
        for (i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] <= 0) continue;
            this.lowestBin = i;
            break;
        }
        for (i = this.counts.length - 1; i >= 0; --i) {
            if (this.counts[i] <= 0) continue;
            this.highestBin = i;
            break;
        }
        LOG.fine(() -> String.format("min=%d max=%d", this.lowestBin, this.highestBin));
    }

    public int[] computeCDF() {
        int[] cdf = new int[this.counts.length];
        int cum = 0;
        for (int i = this.lowestBin; i <= this.highestBin; ++i) {
            cdf[i] = cum += this.counts[i];
        }
        return cdf;
    }

    public int getHighestOccupiedBin() {
        return this.highestBin;
    }

    public int getLowestOccupiedBin() {
        return this.lowestBin;
    }

    public int getCount(int bin) {
        return this.counts[bin];
    }
}

