/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio;

import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Random;
import org.lsst.fits.imageio.CameraImageReader;
import org.lsst.fits.imageio.cmap.RGBColorMap;

public class EnhancedScalingUtils {
    private static final int MAX_BINS = 100000;
    private float min;
    private float max;
    private float binSize;
    private final int[] histogram;
    private int nEntries;
    private final int[] rgb;

    EnhancedScalingUtils(FloatBuffer data, RGBColorMap colorMap) {
        this.histogram = this.fillHistogram(100000, data);
        this.rgb = this.computeCDF(this.histogram, this.nEntries, colorMap);
    }

    private int[] fillHistogram(int bins, FloatBuffer data) {
        float min = 0.0f;
        float max = 1.0f;
        int[] histogram = new int[bins];
        float binSize = (max - min) / (float)bins;
        int nEntries = 0;
        while (data.hasRemaining()) {
            float f = data.get();
            int bin = this.binFor(min, binSize, f);
            if (bin >= bins) {
                rebinFactor = (int)Math.ceil((min - f) / (min - max));
                k = 0;
                for (i = 0; i < bins; i += rebinFactor) {
                    newCount = 0;
                    for (j = 0; j < rebinFactor; ++j) {
                        if (i + j >= bins) continue;
                        newCount += histogram[i + j];
                    }
                    histogram[k++] = newCount;
                }
                Arrays.fill(histogram, k, bins, 0);
                max = min + (float)bins * (binSize *= (float)rebinFactor);
                bin = this.binFor(min, binSize, f);
            } else if (bin < 0) {
                rebinFactor = (int)Math.ceil((f - max) / (min - max));
                k = bins;
                for (i = bins - rebinFactor; i > 0 - rebinFactor; i -= rebinFactor) {
                    newCount = 0;
                    for (j = 0; j < rebinFactor; ++j) {
                        if (i + j < 0) continue;
                        newCount += histogram[i + j];
                    }
                    histogram[--k] = newCount;
                }
                Arrays.fill(histogram, 0, k, 0);
                min = max - (float)bins * (binSize *= (float)rebinFactor);
                bin = this.binFor(min, binSize, f);
            }
            int n = bin;
            histogram[n] = histogram[n] + 1;
            ++nEntries;
        }
        this.min = min;
        this.max = max;
        this.binSize = binSize;
        this.nEntries = nEntries;
        return histogram;
    }

    private int[] computeCDF(int[] histogram, int nEntries, RGBColorMap colorMap) {
        int[] cdf = new int[histogram.length];
        int size = colorMap.getSize() - 1;
        float cum = 0.0f;
        for (int i = 0; i < histogram.length; ++i) {
            cdf[i] = colorMap.getRGB((int)Math.floor((float)size * (cum += (float)histogram[i]) / (float)nEntries));
        }
        return cdf;
    }

    private int binFor(float min, float binSize, float f) {
        return (int)Math.floor((f - min) / binSize);
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float getBinSize() {
        return this.binSize;
    }

    public int[] getHistogram() {
        return this.histogram;
    }

    public int getEntries() {
        return this.nEntries;
    }

    int getRGB(float value) {
        return this.rgb[this.binFor(this.min, this.binSize, value)];
    }

    public String toString() {
        return "EnhancedScalingUtils{min=" + this.min + ", max=" + this.max + ", binSize=" + this.binSize + ", nEntries=" + this.nEntries + "\n histogram=" + Arrays.toString(this.histogram) + "\n rgb=" + Arrays.toString(this.rgb) + "}";
    }

    public static void main(String[] args) {
        FloatBuffer buffer = FloatBuffer.allocate(1000);
        Random random = new Random();
        while (buffer.hasRemaining()) {
            buffer.put((float)random.nextGaussian(10.0, 3.0));
        }
        buffer.flip();
        EnhancedScalingUtils esu = new EnhancedScalingUtils(buffer, CameraImageReader.DEFAULT_COLOR_MAP);
        System.out.println(esu);
        int count = Arrays.stream(esu.getHistogram()).sum();
        System.out.println(count);
    }
}

