/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import nom.tam.fits.FitsFactory;
import org.lsst.fits.imageio.CachingReader;
import org.lsst.fits.imageio.CameraImageReadParam;
import org.lsst.fits.imageio.RawData;
import org.lsst.fits.imageio.Segment;
import org.lsst.fits.imageio.bias.BiasCorrection;
import org.lsst.fits.imageio.bias.NullBiasCorrection;
import org.lsst.fits.imageio.bias.SerialParallelBiasCorrection;
import org.lsst.fits.imageio.cmap.RGBColorMap;
import org.lsst.fits.imageio.cmap.SAOColorMap;

public class CameraImageReader
extends ImageReader {
    private static final Logger LOG = Logger.getLogger(CameraImageReader.class.getName());
    private static final CachingReader READER = new CachingReader();
    public static final ImageTypeSpecifier IMAGE_TYPE = ImageTypeSpecifier.createFromBufferedImageType(1);
    public static final RGBColorMap DEFAULT_COLOR_MAP = new SAOColorMap(256, "grey.sao");
    public static final BiasCorrection DEFAULT_BIAS_CORRECTION = new NullBiasCorrection();
    private static final int IMAGE_OFFSET = 100;
    private char wcsString;
    private BiasCorrection biasCorrection;
    private CameraImageReadParam.Scale scale;
    private boolean showBiasRegion;
    private ImageType imageType;

    public CameraImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public CameraImageReadParam getDefaultReadParam() {
        CameraImageReadParam fitsImageReadParam = new CameraImageReadParam();
        fitsImageReadParam.setBiasCorrection(new SerialParallelBiasCorrection());
        return fitsImageReadParam;
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        int lines = READER.preReadImage((ImageInputStream)input);
        this.imageType = lines > 9 ? ImageType.FOCAL_PLANE : (lines == 1 ? ImageType.CCD : ImageType.RAFT);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        return switch (this.imageType) {
            case ImageType.CCD -> 4072 + (this.showBiasRegion ? 1600 : 0);
            case ImageType.RAFT -> 12688 + (this.showBiasRegion ? 1600 : 0);
            default -> 63040;
        };
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        return switch (this.imageType) {
            case ImageType.CCD -> 4000 + (this.showBiasRegion ? 1600 : 0);
            case ImageType.RAFT -> 12688 + (this.showBiasRegion ? 1600 : 0);
            default -> 63040;
        };
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        return Collections.singleton(IMAGE_TYPE).iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    private void initialize(ImageReadParam param) {
        CameraImageReadParam.Scale localScale;
        int localWcsString;
        BiasCorrection bc;
        if (param instanceof CameraImageReadParam) {
            CameraImageReadParam cameraParam = (CameraImageReadParam)param;
            bc = cameraParam.getBiasCorrection();
            this.showBiasRegion = cameraParam.isShowBiasRegions();
            localWcsString = cameraParam.getWCSString();
            localScale = cameraParam.getScale();
        } else {
            bc = DEFAULT_BIAS_CORRECTION;
            this.showBiasRegion = false;
            localWcsString = 32;
            localScale = CameraImageReadParam.Scale.AMPLIFIER;
        }
        if (localWcsString == 32) {
            localWcsString = this.imageType == ImageType.FOCAL_PLANE ? 69 : (this.imageType == ImageType.RAFT ? 81 : 66);
        }
        this.wcsString = (char)localWcsString;
        this.biasCorrection = bc;
        this.scale = localScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        Graphics2D g;
        BufferedImage result;
        long[] globalScale;
        BiasCorrection bc;
        RGBColorMap cmap;
        Rectangle sourceRegion;
        int xSubSampling = 1;
        int ySubSampling = 1;
        if (param != null) {
            LOG.log(Level.INFO, "read called sourceRegion={0}", param.getSourceRegion());
            LOG.log(Level.INFO, "read called destination={0}", param.getDestination());
            LOG.log(Level.INFO, "read called renderSize={0}", param.getSourceRenderSize());
            LOG.log(Level.INFO, "read called xsub={0}", param.getSourceXSubsampling());
            LOG.log(Level.INFO, "read called ysub={0}", param.getSourceYSubsampling());
            LOG.log(Level.INFO, "read called xoffsub={0}", param.getSubsamplingXOffset());
            LOG.log(Level.INFO, "read called yoffsub={0}", param.getSubsamplingYOffset());
            xSubSampling = param.getSourceXSubsampling();
            ySubSampling = param.getSourceYSubsampling();
        }
        this.initialize(param);
        Map<String, Map<String, Object>> wcsOverride = null;
        Rectangle rectangle = sourceRegion = param == null ? null : param.getSourceRegion();
        if (param instanceof CameraImageReadParam) {
            CameraImageReadParam cameraParam = (CameraImageReadParam)param;
            cmap = cameraParam.getColorMap();
            bc = cameraParam.getBiasCorrection();
            globalScale = cameraParam.getGlobalScale();
            wcsOverride = cameraParam.getWCSOverride();
        } else {
            cmap = DEFAULT_COLOR_MAP;
            bc = DEFAULT_BIAS_CORRECTION;
            globalScale = null;
        }
        if (sourceRegion == null) {
            result = IMAGE_TYPE.createBufferedImage(this.getWidth(0) / xSubSampling, this.getHeight(0) / ySubSampling);
            g = result.createGraphics();
            g.translate(0, this.getHeight(0) / ySubSampling);
            g.scale(1.0 / (double)xSubSampling, -1.0 / (double)ySubSampling);
        } else {
            sourceRegion = new Rectangle(sourceRegion.x, this.getHeight(0) - sourceRegion.y - sourceRegion.height, sourceRegion.width, sourceRegion.height);
            result = IMAGE_TYPE.createBufferedImage((int)(sourceRegion.getWidth() / (double)xSubSampling), (int)(sourceRegion.getHeight() / (double)ySubSampling));
            g = result.createGraphics();
            g.translate(0.0, sourceRegion.getHeight() / (double)ySubSampling);
            g.scale(1.0 / (double)xSubSampling, -1.0 / (double)ySubSampling);
            g.translate(-sourceRegion.getX(), -sourceRegion.getY());
        }
        try {
            if (this.scale == CameraImageReadParam.Scale.AMPLIFIER || globalScale != null) {
                READER.readImage((ImageInputStream)this.getInput(), sourceRegion, g, cmap, bc, this.showBiasRegion, this.wcsString, globalScale, wcsOverride);
            } else {
                READER.readImageWithOnTheFlyGlobalScale((ImageInputStream)this.getInput(), sourceRegion, g, cmap, bc, this.showBiasRegion, this.wcsString, wcsOverride);
            }
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        finally {
            g.dispose();
        }
    }

    public Segment getImageMetaDataForPoint(ImageReadParam param, int x, int y) {
        this.initialize(param);
        Rectangle region = new Rectangle(x, y, 1, 1);
        List<Segment> readSegments = READER.readSegments((ImageInputStream)this.getInput(), this.wcsString);
        for (Segment segment : readSegments) {
            if (!segment.intersects(region)) continue;
            return segment;
        }
        return null;
    }

    public Number getPixelForSegment(Segment segment, int x, int y) {
        Number number;
        RawData rawData = READER.getRawData(segment);
        Object buffer = rawData.getBuffer();
        int p = segment.getDataSec().x + x + y * segment.getNAxis1();
        if (buffer instanceof IntBuffer) {
            IntBuffer iBuffer = (IntBuffer)buffer;
            number = iBuffer.get(p);
        } else if (buffer instanceof FloatBuffer) {
            FloatBuffer fBuffer = (FloatBuffer)buffer;
            number = Float.valueOf(fBuffer.get(p));
        } else {
            number = 0;
        }
        return number;
    }

    public int getRGBForSegment(Segment segment, int x, int y) {
        if (this.scale == CameraImageReadParam.Scale.GLOBAL) {
            long[] globalScale = READER.getGlobalScale((ImageInputStream)this.getInput(), this.biasCorrection, this.wcsString, null);
            BufferedImage image = READER.getBufferedImage(segment, this.biasCorrection, globalScale);
            return image.getRGB(x + segment.getDataSec().x, y + segment.getDataSec().y);
        }
        BufferedImage image = READER.getBufferedImage(segment, this.biasCorrection, null);
        return image.getRGB(x + segment.getDataSec().x, y + segment.getDataSec().y);
    }

    public BiasCorrection.CorrectionFactors getCorrectionFactorForSegment(Segment segment) {
        return READER.getCorrectionFactors(segment, this.biasCorrection);
    }

    public List<SegmentGeometry> getSegmentGeometry(ImageReadParam param) {
        this.initialize(param);
        List<Segment> readSegments = READER.readSegments((ImageInputStream)this.getInput(), this.wcsString);
        return readSegments.stream().map(s -> new SegmentGeometry((Segment)s)).collect(Collectors.toList());
    }

    static {
        FitsFactory.setUseHierarch((boolean)true);
    }

    public static enum ImageType {
        FOCAL_PLANE,
        RAFT,
        CCD;

    }

    public static class SegmentGeometry {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final String segmentName;
        private final String raftBay;
        private final String ccdSlot;
        private final double[] flatmatrix;

        public SegmentGeometry(Segment segment) {
            Rectangle2D.Double wcs = segment.getWcs();
            this.x = (int)Math.round(wcs.x);
            this.y = (int)Math.round(wcs.y);
            this.width = (int)Math.round(wcs.width);
            this.height = (int)Math.round(wcs.height);
            this.segmentName = segment.getSegmentName();
            this.raftBay = segment.getRaftBay();
            this.ccdSlot = segment.getCcdSlot();
            this.flatmatrix = new double[6];
            AffineTransform wcsTranslation = segment.getWCSTranslation(false);
            try {
                AffineTransform inverse = wcsTranslation.createInverse();
                inverse.getMatrix(this.flatmatrix);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public String getSegmentName() {
            return this.segmentName;
        }

        public String getRaftBay() {
            return this.raftBay;
        }

        public String getCcdSlot() {
            return this.ccdSlot;
        }

        public double[] getFlatmatrix() {
            return this.flatmatrix;
        }
    }
}

