/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.imageio.ImageReadParam;
import org.lsst.fits.imageio.CameraImageReader;
import org.lsst.fits.imageio.bias.BiasCorrection;
import org.lsst.fits.imageio.bias.SerialParallelBiasCorrection;
import org.lsst.fits.imageio.bias.SerialParallelBiasSub;
import org.lsst.fits.imageio.bias.SerialParallelBiasSubtraction;
import org.lsst.fits.imageio.bias.SerialParallelBiasSubtraction2;
import org.lsst.fits.imageio.cmap.RGBColorMap;
import org.lsst.fits.imageio.cmap.SAOColorMap;

public class CameraImageReadParam
extends ImageReadParam {
    private boolean showBiasRegions = false;
    private final GetSetAvailable<BiasCorrection> bc;
    private final GetSetAvailable<RGBColorMap> colorMap;
    private char wcsString = (char)32;
    private long[] globalScale;
    private Map<String, Map<String, Object>> wcsOverride = null;
    private Scale scale = Scale.AMPLIFIER;

    public CameraImageReadParam() {
        LinkedHashMap<String, BiasCorrection> biasCorrectionOptions = new LinkedHashMap<String, BiasCorrection>();
        biasCorrectionOptions.put("None", CameraImageReader.DEFAULT_BIAS_CORRECTION);
        biasCorrectionOptions.put("Simple Overscan Correction", new SerialParallelBiasCorrection());
        biasCorrectionOptions.put("Simple Overscan Subtraction", new SerialParallelBiasSubtraction());
        biasCorrectionOptions.put("Simple Overscan Subtraction2", new SerialParallelBiasSubtraction2());
        biasCorrectionOptions.put("Simple Overscan Subtraction only", new SerialParallelBiasSub());
        this.bc = new GetSetAvailable<BiasCorrection>(CameraImageReader.DEFAULT_BIAS_CORRECTION, "Bias Correction", biasCorrectionOptions);
        LinkedHashMap<String, SAOColorMap> colorMapOptions = new LinkedHashMap<String, SAOColorMap>();
        colorMapOptions.put("grey", new SAOColorMap(256, "grey.sao"));
        colorMapOptions.put("a", new SAOColorMap(256, "a.sao"));
        colorMapOptions.put("b", new SAOColorMap(256, "b.sao"));
        colorMapOptions.put("bb", new SAOColorMap(256, "bb.sao"));
        colorMapOptions.put("cubehelix0", new SAOColorMap(256, "cubehelix0.sao"));
        colorMapOptions.put("cubehelix1", new SAOColorMap(256, "cubehelix1.sao"));
        colorMapOptions.put("rainbow", new SAOColorMap(256, "rainbow.sao"));
        colorMapOptions.put("standard", new SAOColorMap(256, "standard.sao"));
        this.colorMap = new GetSetAvailable<RGBColorMap>(CameraImageReader.DEFAULT_COLOR_MAP, "Color Map", colorMapOptions);
    }

    public boolean isShowBiasRegions() {
        return this.showBiasRegions;
    }

    public void setShowBiasRegions(boolean showBiasRegions) {
        this.showBiasRegions = showBiasRegions;
    }

    public char getWCSString() {
        return this.wcsString;
    }

    public void setWCSString(char wcsString) {
        this.wcsString = wcsString;
    }

    public RGBColorMap getColorMap() {
        return this.colorMap.getValue();
    }

    public void setColorMap(RGBColorMap colorMap) {
        this.colorMap.setValue(colorMap);
    }

    public Set<String> getAvailableColorMaps() {
        return this.colorMap.getAvailable();
    }

    public void setColorMap(String name) {
        this.colorMap.setValue(name);
    }

    public String getColorMapName() {
        return this.colorMap.getValueName();
    }

    public BiasCorrection getBiasCorrection() {
        return this.bc.getValue();
    }

    public void setBiasCorrection(BiasCorrection bc) {
        this.bc.setValue(bc);
    }

    public Set<String> getAvailableBiasCorrections() {
        return this.bc.getAvailable();
    }

    public void setBiasCorrection(String name) {
        this.bc.setValue(name);
    }

    public String getBiasCorrectionName() {
        return this.bc.getValueName();
    }

    public long[] getGlobalScale() {
        return this.globalScale;
    }

    public void setGlobalScale(long[] globalScale) {
        this.globalScale = globalScale;
    }

    public Map<String, Map<String, Object>> getWCSOverride() {
        return this.wcsOverride;
    }

    public void setWCSOverride(Map<String, Map<String, Object>> wcsOverride) {
        this.wcsOverride = wcsOverride;
    }

    public Scale getScale() {
        return this.scale;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    public static enum Scale {
        GLOBAL,
        AMPLIFIER;

    }

    private static class GetSetAvailable<T> {
        private T value;
        private final Map<String, T> available;
        private final String type;

        public GetSetAvailable(T initial, String type, Map<String, T> available) {
            this.value = initial;
            this.available = available;
            this.type = type;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public Set<String> getAvailable() {
            return Collections.unmodifiableSet(this.available.keySet());
        }

        public void setValue(String name) {
            if (!this.available.containsKey(name)) {
                throw new IllegalArgumentException("Unknown " + this.type + ": " + name);
            }
            this.setValue(this.available.get(name));
        }

        public String getValueName() {
            for (Map.Entry<String, T> entry : this.available.entrySet()) {
                if (!Objects.equals(entry.getValue(), this.value)) continue;
                return entry.getKey();
            }
            return null;
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.value);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            GetSetAvailable other = (GetSetAvailable)obj;
            return Objects.equals(this.value, other.value);
        }
    }
}

