/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Weigher;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.LookupOp;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.stream.ImageInputStream;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.BufferedFile;
import org.lsst.fits.imageio.CameraImageReader;
import org.lsst.fits.imageio.EnhancedScalingUtils;
import org.lsst.fits.imageio.RawData;
import org.lsst.fits.imageio.ScalingUtils;
import org.lsst.fits.imageio.Segment;
import org.lsst.fits.imageio.Timed;
import org.lsst.fits.imageio.bias.BiasCorrection;
import org.lsst.fits.imageio.bias.NullBiasCorrection;
import org.lsst.fits.imageio.cmap.RGBColorMap;

public class CachingReader {
    private final AsyncLoadingCache<SegmentCacheKey, List<Segment>> segmentCache = Caffeine.newBuilder().maximumSize((long)Integer.getInteger("org.lsst.fits.imageio.segmentCacheSize", 10000).intValue()).recordStats().buildAsync(key -> Timed.execute(() -> CachingReader.readSegment(key.line, key.wcsLetter.charValue(), key.wcsOverride), "Loading %s took %dms", key.line));
    private final AsyncLoadingCache<Segment, RawData> rawDataCache;
    private final AsyncLoadingCache<SegmentBiasCorrectionAndCounts, BufferedImage> bufferedImageCache;
    private final AsyncLoadingCache<SegmentListAndBiasCorrection, long[]> globalScalingCache;
    private final AsyncLoadingCache<SegmentAndBiasCorrection, BiasCorrection.CorrectionFactors> biasCorrectionCache;
    private final LoadingCache<ImageInputStream, List<String>> linesCache;
    private static final Logger LOG = Logger.getLogger(CachingReader.class.getName());

    public CachingReader() {
        Weigher rawDataWeigher = (k1, rawData) -> ((Buffer)rawData.getBuffer()).capacity() * 4;
        this.rawDataCache = Caffeine.newBuilder().weigher(rawDataWeigher).maximumWeight(Long.getLong("org.lsst.fits.imageio.rawDataCacheSizeBytes", 1000000000L).longValue()).recordStats().buildAsync((segment, executor) -> segment.readRawDataAsync(executor));
        this.biasCorrectionCache = Caffeine.newBuilder().maximumSize((long)Integer.getInteger("org.lsst.fits.imageio.biasCorrectionCacheSize", 10000).intValue()).recordStats().buildAsync((key, executor) -> {
            Segment segment = key.segment;
            return this.rawDataCache.get((Object)segment).thenApply(rawData -> {
                Object patt4615$temp = rawData.getBuffer();
                if (patt4615$temp instanceof IntBuffer) {
                    IntBuffer intBuffer = (IntBuffer)patt4615$temp;
                    return key.biasCorrection.compute(intBuffer, segment);
                }
                return new NullBiasCorrection().compute(null, segment);
            });
        });
        Weigher buffedImageWeigher = (k1, bi) -> bi.getHeight() * bi.getWidth() * 4;
        this.bufferedImageCache = Caffeine.newBuilder().weigher(buffedImageWeigher).maximumWeight(Long.getLong("org.lsst.fits.imageio.bufferedImageCacheSizeBytes", 5000000000L).longValue()).recordStats().buildAsync((key, executor) -> this.rawDataCache.get((Object)key.segment).thenApply(rawData -> (BufferedImage)((CompletableFuture)this.biasCorrectionCache.get((Object)new SegmentAndBiasCorrection(key.segment, key.biasCorrection)).thenApply(factors -> Timed.execute(() -> {
            if (rawData.getBuffer() instanceof IntBuffer) {
                return CachingReader.createBufferedImage(rawData, factors, key.counts);
            }
            return CachingReader.createBufferedImage(rawData);
        }, "Loading buffered image for segment %s took %dms", key.segment))).join()));
        this.globalScalingCache = Caffeine.newBuilder().maximumSize((long)Integer.getInteger("org.lsst.fits.imageio.globalScalingCacheSize", 10000).intValue()).recordStats().buildAsync((key, executor) -> {
            LOG.log(Level.FINE, "Building global scale for {0} {1} {2}", new Object[]{key.hashCode(), key.segments.hashCode(), key.biasCorrection.hashCode()});
            ArrayList<CompletionStage> histograms = new ArrayList<CompletionStage>();
            for (Segment segment : key.segments) {
                histograms.add(this.rawDataCache.get((Object)segment).thenApply(rawData -> (ScalingUtils)((CompletableFuture)this.biasCorrectionCache.get((Object)new SegmentAndBiasCorrection(segment, key.biasCorrection)).thenApply(correctionFactors -> {
                    IntBuffer intData = (IntBuffer)rawData.getBuffer();
                    return CachingReader.histogram(segment.getDataSec(), intData, segment, correctionFactors);
                })).join()));
            }
            return CompletableFuture.allOf((CompletableFuture[])histograms.toArray(CompletableFuture[]::new)).thenApply(v -> {
                try {
                    long[] counts = new long[262144];
                    for (CompletableFuture future : histograms) {
                        ScalingUtils su = (ScalingUtils)future.get();
                        LOG.log(Level.FINE, "Adding bins with max {0}", su.getHighestOccupiedBin());
                        for (int i = su.getLowestOccupiedBin(); i <= su.getHighestOccupiedBin(); ++i) {
                            int n = i;
                            counts[n] = counts[n] + (long)su.getCount(i);
                        }
                    }
                    return counts;
                }
                catch (InterruptedException | ExecutionException x) {
                    throw new RuntimeException("Error computing global scale", x);
                }
            });
        });
        this.linesCache = Caffeine.newBuilder().maximumSize((long)Integer.getInteger("org.lsst.fits.imageio.linesCacheSize", 10000).intValue()).build(in -> Timed.execute(() -> {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            in.seek(0L);
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                lines.add(line);
            }
            return lines;
        }, "Read lines in %dms", new Object[0]));
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                CachingReader.this.report();
            }
        }, 60000L, 60000L);
    }

    void report() {
        LoadingCache s1 = this.segmentCache.synchronous();
        LOG.log(Level.INFO, "segment Cache size {0} stats {1}", new Object[]{s1.estimatedSize(), s1.stats()});
        LoadingCache s2 = this.rawDataCache.synchronous();
        LOG.log(Level.INFO, "rawData Cache size {0} stats {1}", new Object[]{s2.estimatedSize(), s2.stats()});
        LoadingCache s3 = this.bufferedImageCache.synchronous();
        LOG.log(Level.INFO, "bufferedImage Cache size {0} stats {1}", new Object[]{s3.estimatedSize(), s3.stats()});
        LoadingCache s4 = this.globalScalingCache.synchronous();
        LOG.log(Level.INFO, "globalScaling Cache size {0} stats {1}", new Object[]{s4.estimatedSize(), s4.stats()});
        LoadingCache s5 = this.biasCorrectionCache.synchronous();
        LOG.log(Level.INFO, "biasCorrection Cache size {0} stats {1}", new Object[]{s5.estimatedSize(), s5.stats()});
    }

    int preReadImage(ImageInputStream fileInput) {
        List lines = (List)this.linesCache.get((Object)fileInput);
        return lines == null ? 0 : lines.size();
    }

    void readImage(ImageInputStream fileInput, Rectangle sourceRegion, Graphics2D g, RGBColorMap cmap, BiasCorrection bc, boolean showBiasRegion, char wcsLetter, long[] globalScale, Map<String, Map<String, Object>> wcsOverride) throws IOException {
        try {
            ConcurrentLinkedQueue segmentsCompletables = new ConcurrentLinkedQueue();
            ConcurrentLinkedQueue bufferedImageCompletables = new ConcurrentLinkedQueue();
            List lines = (List)this.linesCache.get((Object)fileInput);
            lines.stream().map(line -> this.segmentCache.get((Object)new SegmentCacheKey((String)line, Character.valueOf(wcsLetter), wcsOverride))).forEach(futureSegments -> segmentsCompletables.add(futureSegments.thenAccept(segments -> {
                List<Segment> segmentsToRead = this.computeSegmentsToRead((List<Segment>)segments, sourceRegion);
                segmentsToRead.stream().forEach(segment -> {
                    CompletableFuture fbi = this.bufferedImageCache.get((Object)new SegmentBiasCorrectionAndCounts((Segment)segment, bc, globalScale));
                    bufferedImageCompletables.add(fbi.thenAccept(bi -> Timed.execute(() -> {
                        BufferedImage subimage;
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.transform(segment.getWCSTranslation(showBiasRegion));
                        if (showBiasRegion) {
                            subimage = bi;
                        } else {
                            Rectangle datasec = segment.getDataSec();
                            subimage = bi.getSubimage(datasec.x, datasec.y, datasec.width, datasec.height);
                        }
                        if (cmap != CameraImageReader.DEFAULT_COLOR_MAP) {
                            LookupOp op = cmap.getLookupOp();
                            subimage = op.filter(subimage, null);
                        }
                        g2.drawImage((Image)subimage, 0, 0, null);
                        g2.dispose();
                        return null;
                    }, "drawImage for segment %s took %dms", segment)));
                });
            })));
            LOG.log(Level.INFO, "Waiting for {0} files", segmentsCompletables.size());
            CompletableFuture.allOf((CompletableFuture[])segmentsCompletables.toArray(CompletableFuture[]::new)).join();
            LOG.log(Level.INFO, "Waiting for {0} buffered images", bufferedImageCompletables.size());
            CompletableFuture.allOf((CompletableFuture[])bufferedImageCompletables.toArray(CompletableFuture[]::new)).join();
            LOG.log(Level.INFO, "Done waiting");
        }
        catch (CompletionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof IOException) {
                IOException iOException = (IOException)cause;
                throw iOException;
            }
            throw new IOException("Unexpected exception during image reading", cause);
        }
    }

    void readImageWithOnTheFlyGlobalScale(ImageInputStream fileInput, Rectangle sourceRegion, Graphics2D g, RGBColorMap cmap, BiasCorrection bc, boolean showBiasRegion, char wcsLetter, Map<String, Map<String, Object>> wcsOverride) throws IOException {
        try {
            ConcurrentLinkedQueue segmentsCompletables = new ConcurrentLinkedQueue();
            ConcurrentLinkedQueue bufferedImageCompletables = new ConcurrentLinkedQueue();
            ConcurrentLinkedQueue<CompletionStage> globalScaleCompletable = new ConcurrentLinkedQueue<CompletionStage>();
            List lines = (List)this.linesCache.get((Object)fileInput);
            ArrayList<Segment> allSegments = new ArrayList<Segment>();
            lines.stream().map(line -> this.segmentCache.get((Object)new SegmentCacheKey((String)line, Character.valueOf(wcsLetter), wcsOverride))).forEach(futureSegments -> segmentsCompletables.add(futureSegments.thenAccept(segments -> allSegments.addAll((Collection<Segment>)segments))));
            LOG.log(Level.INFO, "Waiting for {0} files", segmentsCompletables.size());
            CompletableFuture.allOf((CompletableFuture[])segmentsCompletables.toArray(CompletableFuture[]::new)).join();
            globalScaleCompletable.add(this.globalScalingCache.get((Object)new SegmentListAndBiasCorrection(allSegments, bc)).thenAccept(globalScale -> {
                List<Segment> segmentsToRead = this.computeSegmentsToRead(allSegments, sourceRegion);
                segmentsToRead.stream().forEach(segment -> {
                    CompletableFuture fbi = this.bufferedImageCache.get((Object)new SegmentBiasCorrectionAndCounts((Segment)segment, bc, (long[])globalScale));
                    bufferedImageCompletables.add(fbi.thenAccept(bi -> Timed.execute(() -> {
                        BufferedImage subimage;
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.transform(segment.getWCSTranslation(showBiasRegion));
                        if (showBiasRegion) {
                            subimage = bi;
                        } else {
                            Rectangle datasec = segment.getDataSec();
                            subimage = bi.getSubimage(datasec.x, datasec.y, datasec.width, datasec.height);
                        }
                        if (cmap != CameraImageReader.DEFAULT_COLOR_MAP) {
                            LookupOp op = cmap.getLookupOp();
                            subimage = op.filter(subimage, null);
                        }
                        g2.drawImage((Image)subimage, 0, 0, null);
                        g2.dispose();
                        return null;
                    }, "drawImage for segment %s took %dms", segment)));
                });
            }));
            LOG.log(Level.INFO, "Waiting for {0} global scales", globalScaleCompletable.size());
            CompletableFuture.allOf((CompletableFuture[])globalScaleCompletable.toArray(CompletableFuture[]::new)).join();
            LOG.log(Level.INFO, "Waiting for {0} buffered images", bufferedImageCompletables.size());
            CompletableFuture.allOf((CompletableFuture[])bufferedImageCompletables.toArray(CompletableFuture[]::new)).join();
            LOG.log(Level.INFO, "Done waiting");
        }
        catch (CompletionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof IOException) {
                IOException iOException = (IOException)cause;
                throw iOException;
            }
            throw new IOException("Unexpected exception during image reading", cause);
        }
    }

    private List<Segment> computeSegmentsToRead(List<Segment> segments, Rectangle sourceRegion) {
        if (sourceRegion == null) {
            return segments;
        }
        return segments.stream().filter(segment -> segment.intersects(sourceRegion)).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<Segment> readSegment(String line, char wcsLetter, Map<String, Map<String, Object>> wcsOverride) throws IOException, TruncatedFileException, FitsException {
        if (line.startsWith("DAQ:")) {
            return CachingReader.readDAQSegment(line, wcsLetter, wcsOverride);
        }
        return CachingReader.readFitsFileSegment(new File(line), wcsLetter, wcsOverride);
    }

    private static List<Segment> readDAQSegment(String line, char wcsLetter, Map<String, Map<String, Object>> wcsOverride) throws IOException {
        Pattern pattern = Pattern.compile("DAQ:(\\w+):(\\w+)/(\\w+):(\\w+)/(\\w+)");
        Matcher matcher = pattern.matcher(line);
        if (!matcher.matches()) {
            throw new IOException("Illegal image segment descriptor: " + line);
        }
        String partition = matcher.group(1);
        String folder = matcher.group(2);
        String imageName = matcher.group(3);
        String raftName = matcher.group(4);
        String rebName = matcher.group(5);
        throw new IOException("Unsupported operation exception: " + line);
    }

    private static List<Segment> readFitsFileSegment(File file, char wcsLetter, Map<String, Map<String, Object>> wcsOverride) throws IOException, TruncatedFileException, FitsException {
        ArrayList<Segment> result = new ArrayList<Segment>();
        String ccdSlot = null;
        String raftBay = null;
        int nSegments = 16;
        boolean isDMFile = false;
        try (BufferedFile bf = new BufferedFile(file, "r");){
            for (int i = 0; i < nSegments + 1; ++i) {
                Header header = new Header((ArrayDataInput)bf);
                if (i == 0) {
                    raftBay = header.getStringValue("RAFTBAY");
                    ccdSlot = header.getStringValue("CCDSLOT");
                    long expId = header.getLongValue("EXPID");
                    if (ccdSlot == null) {
                        ccdSlot = header.getStringValue("SENSNAME");
                    }
                    if (ccdSlot == null) {
                        throw new IOException("Missing CCDSLOT while reading " + file);
                    }
                    if (expId != 0L) {
                        nSegments = 1;
                        isDMFile = true;
                    } else if (ccdSlot.startsWith("SW")) {
                        nSegments = 8;
                    }
                }
                if (i <= 0) continue;
                if (isDMFile) {
                    int naxis2;
                    int naxis1;
                    wcsLetter = (char)68;
                    HashMap<String, Object> dmWCSOverride = new HashMap<String, Object>();
                    boolean isCompressed = header.getBooleanValue("ZIMAGE");
                    if (isCompressed) {
                        naxis1 = header.getIntValue("ZNAXIS1");
                        naxis2 = header.getIntValue("ZNAXIS2");
                    } else {
                        naxis1 = header.getIntValue("NAXIS1");
                        naxis2 = header.getIntValue("NAXIS2");
                    }
                    dmWCSOverride.put("DATASEC", String.format("[1:%d,1:%d]", naxis1, naxis2));
                    dmWCSOverride.put("PC1_1D", 1.0);
                    dmWCSOverride.put("PC1_2D", 0.0);
                    dmWCSOverride.put("PC2_1D", 0.0);
                    dmWCSOverride.put("PC2_2D", 1.0);
                    dmWCSOverride.put("CRVAL1D", 0);
                    dmWCSOverride.put("CRVAL2D", 0);
                    Segment segment = new Segment(header, file, bf, raftBay, ccdSlot, wcsLetter, dmWCSOverride);
                    result.add(segment);
                    continue;
                }
                String extName = header.getStringValue("EXTNAME");
                String wcsKey = String.format("%s/%s/%s", raftBay, ccdSlot, extName.substring(7, 9));
                Segment segment = new Segment(header, file, bf, raftBay, ccdSlot, wcsLetter, wcsOverride == null ? null : wcsOverride.get(wcsKey));
                result.add(segment);
            }
        }
        return result;
    }

    private static BufferedImage createBufferedImage(RawData<FloatBuffer> rawData) {
        FloatBuffer floatBuffer = rawData.getBuffer();
        EnhancedScalingUtils esu = new EnhancedScalingUtils(floatBuffer, CameraImageReader.DEFAULT_COLOR_MAP);
        Segment segment = rawData.getSegment();
        Rectangle datasec = segment.getDataSec();
        BufferedImage image = CameraImageReader.IMAGE_TYPE.createBufferedImage(segment.getNAxis1(), segment.getNAxis2());
        WritableRaster raster = image.getRaster();
        DataBuffer db = raster.getDataBuffer();
        for (int y = datasec.y; y < datasec.height + datasec.y; ++y) {
            int p = datasec.x + y * segment.getNAxis1();
            for (int x = datasec.x; x < datasec.width + datasec.x; ++x) {
                float f = floatBuffer.get(p);
                db.setElem(p, esu.getRGB(f));
                ++p;
            }
        }
        return image;
    }

    private static BufferedImage createBufferedImage(RawData<IntBuffer> rawData, BiasCorrection.CorrectionFactors factors, long[] globalScale) {
        ScalingUtils su;
        IntBuffer intBuffer = rawData.getBuffer();
        Segment segment = rawData.getSegment();
        Rectangle datasec = segment.getDataSec();
        if (globalScale != null) {
            su = new ScalingUtils(globalScale);
            LOG.log(Level.FINE, "Global scale max {0}", su.getHighestOccupiedBin());
        } else {
            su = CachingReader.histogram(datasec, intBuffer, segment, factors);
        }
        int max = su.getHighestOccupiedBin();
        int[] cdf = su.computeCDF();
        int range = cdf[max];
        range = 1 + range / 256;
        for (int i = su.getLowestOccupiedBin(); i <= max; ++i) {
            cdf[i] = CameraImageReader.DEFAULT_COLOR_MAP.getRGB(cdf[i] / range);
        }
        BufferedImage image = CameraImageReader.IMAGE_TYPE.createBufferedImage(segment.getNAxis1(), segment.getNAxis2());
        WritableRaster raster = image.getRaster();
        DataBuffer db = raster.getDataBuffer();
        CachingReader.copyAndScaleData(datasec, segment, cdf, intBuffer, factors, db, max);
        return image;
    }

    private static void copyAndScaleData(Rectangle datasec, Segment segment, int[] cdf, IntBuffer intBuffer, BiasCorrection.CorrectionFactors factors, DataBuffer db, int max) {
        for (int y = datasec.y; y < datasec.height + datasec.y; ++y) {
            int p = datasec.x + y * segment.getNAxis1();
            for (int x = datasec.x; x < datasec.width + datasec.x; ++x) {
                int correctionFactor = factors.correctionFactor(x, y);
                int bin = Math.max(intBuffer.get(p) - correctionFactor, 0);
                int rgb = cdf[bin];
                db.setElem(p, rgb);
                ++p;
            }
        }
    }

    private static ScalingUtils histogram(Rectangle datasec, IntBuffer intBuffer, Segment segment, BiasCorrection.CorrectionFactors factors) {
        int[] count = new int[262144];
        for (int y = datasec.y; y < datasec.height + datasec.y; ++y) {
            int p = datasec.x + y * segment.getNAxis1();
            for (int x = datasec.x; x < datasec.width + datasec.x; ++x) {
                int n = Math.max(intBuffer.get(p) - factors.correctionFactor(x, y), 0);
                count[n] = count[n] + 1;
                ++p;
            }
        }
        return new ScalingUtils(count);
    }

    public List<Segment> readSegments(ImageInputStream in, char wcsLetter) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        List lines = (List)this.linesCache.get((Object)in);
        for (String line : lines) {
            result.addAll((List)this.segmentCache.get((Object)new SegmentCacheKey(line, Character.valueOf(wcsLetter), null)).join());
        }
        return result;
    }

    public RawData getRawData(Segment segment) {
        return (RawData)this.rawDataCache.get((Object)segment).join();
    }

    BufferedImage getBufferedImage(Segment segment, BiasCorrection bc, long[] globalScale) {
        SegmentBiasCorrectionAndCounts key = new SegmentBiasCorrectionAndCounts(segment, bc, globalScale);
        CompletableFuture fi = this.bufferedImageCache.get((Object)key);
        return (BufferedImage)fi.join();
    }

    long[] getGlobalScale(ImageInputStream fileInput, BiasCorrection bc, char wcsLetter, Map<String, Map<String, Object>> wcsOverride) {
        ConcurrentLinkedQueue segmentsCompletables = new ConcurrentLinkedQueue();
        List lines = (List)this.linesCache.get((Object)fileInput);
        ArrayList<Segment> allSegments = new ArrayList<Segment>();
        lines.stream().map(line -> this.segmentCache.get((Object)new SegmentCacheKey((String)line, Character.valueOf(wcsLetter), wcsOverride))).forEach(futureSegments -> segmentsCompletables.add(futureSegments.thenAccept(segments -> allSegments.addAll((Collection<Segment>)segments))));
        CompletableFuture.allOf((CompletableFuture[])segmentsCompletables.toArray(CompletableFuture[]::new)).join();
        return (long[])this.globalScalingCache.get((Object)new SegmentListAndBiasCorrection(allSegments, bc)).join();
    }

    BiasCorrection.CorrectionFactors getCorrectionFactors(Segment segment, BiasCorrection bc) {
        return (BiasCorrection.CorrectionFactors)this.biasCorrectionCache.get((Object)new SegmentAndBiasCorrection(segment, bc)).join();
    }

    private record SegmentListAndBiasCorrection(List<Segment> segments, BiasCorrection biasCorrection) {
    }

    private record SegmentCacheKey(String line, Character wcsLetter, Map<String, Map<String, Object>> wcsOverride) {
    }

    private record SegmentBiasCorrectionAndCounts(Segment segment, BiasCorrection biasCorrection, long[] counts) {
    }

    private record SegmentAndBiasCorrection(Segment segment, BiasCorrection biasCorrection) {
    }
}

