/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.fits.imageio.cmap;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.lsst.fits.imageio.cmap.SAOColorMap;

public class SAOColorMapTest {
    @Test
    public void testB() {
        SAOColorMap b = new SAOColorMap(256, "b.sao");
        Assertions.assertEquals((int)0, (int)b.getRGB(0));
        Assertions.assertEquals((int)0xFF0200, (int)b.getRGB(128));
        Assertions.assertEquals((int)0xFFFFFF, (int)b.getRGB(255));
    }

    @Test
    public void testCubeHelix() {
        SAOColorMap cubeHelix = new SAOColorMap(256, "cubehelix00.sao");
        Assertions.assertEquals((int)0, (int)cubeHelix.getRGB(0));
        Assertions.assertEquals((int)10582346, (int)cubeHelix.getRGB(128));
        Assertions.assertEquals((int)0xFFFFFF, (int)cubeHelix.getRGB(255));
    }

    @Test
    public void testMissing() {
        try {
            SAOColorMap saoColorMap = new SAOColorMap(256, "missing.sao");
            Assertions.fail((String)("should not reach here: " + saoColorMap));
        }
        catch (RuntimeException x) {
            Assertions.assertTrue((boolean)x.getMessage().contains("missing.sao"));
        }
    }
}

