/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.trending;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.web.trending.ChannelTree;
import org.lsst.ccs.web.trending.Site;

public class Site
implements AutoCloseable {
    private final String name;
    private final AtomicReference<ChannelTree> channelTree = new AtomicReference();
    private final AtomicBoolean channelTreeInitialized = new AtomicBoolean(false);
    private final CountDownLatch channelTreeInitCompleteLatch = new CountDownLatch(1);
    private final AtomicReference<ChannelTree> fullChannelTree = new AtomicReference();
    private final AtomicBoolean fullChannelTreeInitialized = new AtomicBoolean(false);
    private final CountDownLatch fullChannelTreeInitCompleteLatch = new CountDownLatch(1);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Logger LOG = Logger.getLogger(Site.class.getName());
    private static final int SSH_TIMEOUT = 10000;
    private static final int SSH_RETRIES = 2;
    private int sshTimeout = 10000;
    private int sshRetries = 2;
    private final Set<String> allSources = new LinkedHashSet();
    private Map<String, SessionWrapper> sessionsMap = new LinkedHashMap();
    private final String defaultSource;

    public Site(Properties properties) throws MalformedURLException, JSchException {
        this.name = properties.getProperty("name");
        this.defaultSource = properties.getProperty("defaultSource", "");
        this.allSources.add(this.defaultSource);
        for (Object prop : properties.keySet()) {
            String propStr = (String)prop;
            if (!propStr.endsWith("restURL")) continue;
            String sourceName = propStr.replace("restURL", "");
            if (this.sessionsMap.containsKey(sourceName)) {
                throw new RuntimeException("Source " + sourceName + " is already defined for site " + this.name);
            }
            this.allSources.add(sourceName);
            URL url = new URL(properties.getProperty(propStr));
            boolean useSSH = Boolean.parseBoolean(properties.getProperty(sourceName + "useSSH", "false"));
            SessionWrapper sw = new SessionWrapper(this.name, sourceName, url, useSSH, properties);
            this.sessionsMap.put(sourceName, sw);
        }
    }

    public Set<String> getAvailableSources() {
        return this.allSources;
    }

    public int getSSHTimeout() {
        return this.sshTimeout;
    }

    public final void setSSHTimeout(int sshTimeout) {
        this.sshTimeout = sshTimeout;
    }

    public int getSSHRetries() {
        return this.sshRetries;
    }

    public final void setSSHRetries(int sshRetries) {
        this.sshRetries = sshRetries;
    }

    public InputStream openURL(String relativePath, String source) throws MalformedURLException, IOException {
        String sourceToUse = source == null ? this.defaultSource : source;
        SessionWrapper sessionWrapper = (SessionWrapper)this.sessionsMap.get(sourceToUse);
        if (!sessionWrapper.getUseSSH()) {
            URL url = new URL(sessionWrapper.getRestURL(), relativePath);
            return url.openStream();
        }
        IOException cause = null;
        for (int i = 0; i < this.sshRetries; ++i) {
            sessionWrapper.establishConnection();
            URL url = new URL(sessionWrapper.getTunnelURL(), relativePath);
            try {
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(this.sshTimeout);
                connection.setReadTimeout(this.sshTimeout);
                return connection.getInputStream();
            }
            catch (IOException x) {
                cause = x;
                LOG.log(Level.WARNING, "Failed to connect via ssh to " + url + " (attempt " + i + ")", x);
                sessionWrapper.getSession().disconnect();
                continue;
            }
        }
        throw new IOException("Unable to establish ssh connection after " + this.sshRetries + " retries", cause);
    }

    @Override
    public void close() {
        for (SessionWrapper sw : this.sessionsMap.values()) {
            Session session;
            if (!sw.getUseSSH() || (session = sw.getSession()) == null || !session.isConnected()) continue;
            session.disconnect();
        }
    }

    ChannelTree getChannelTree(boolean refresh) throws IOException {
        1 readChannelTree = new /* Unavailable Anonymous Inner Class!! */;
        if (refresh || !this.channelTreeInitialized.getAndSet(true)) {
            try {
                readChannelTree.run();
            }
            finally {
                this.channelTreeInitCompleteLatch.countDown();
            }
        }
        try {
            this.channelTreeInitCompleteLatch.await();
        }
        catch (InterruptedException x) {
            throw new InterruptedIOException();
        }
        ChannelTree result = (ChannelTree)this.channelTree.get();
        if (result == null) {
            throw new IOException("Channel tree unavailable");
        }
        return result;
    }

    ChannelTree getFullChannelTree(boolean refresh) throws IOException {
        2 readFullChannelTree = new /* Unavailable Anonymous Inner Class!! */;
        if (refresh || !this.fullChannelTreeInitialized.getAndSet(true)) {
            try {
                readFullChannelTree.run();
            }
            finally {
                this.fullChannelTreeInitCompleteLatch.countDown();
            }
        }
        try {
            this.fullChannelTreeInitCompleteLatch.await();
        }
        catch (InterruptedException x) {
            throw new InterruptedIOException();
        }
        ChannelTree result = (ChannelTree)this.fullChannelTree.get();
        if (result == null) {
            throw new IOException("Full channel tree unavailable");
        }
        return result;
    }

    String getName() {
        return this.name;
    }
}

