/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.trending;

import java.util.SortedMap;
import java.util.TreeMap;
import org.lsst.ccs.web.trending.MergedMap;
import org.lsst.ccs.web.trending.TrendingRestInterface;

class MergedMap {
    private final SortedMap<Long, Bin[]> map = new TreeMap();
    private final int nSets;
    private final TrendingRestInterface.ErrorBars errorBars;

    public MergedMap(int nSets, TrendingRestInterface.ErrorBars errorBars) {
        this.nSets = nSets;
        this.errorBars = errorBars;
    }

    void put(String timeString, String valueString, String rmsString, String minString, String maxString, int axis) {
        long time = Long.parseLong(timeString);
        Bin[] bins = (Bin[])this.map.get(time);
        if (bins == null) {
            bins = new Bin[this.nSets];
            this.map.put(time, bins);
        }
        bins[axis] = new Bin(valueString, rmsString, minString, maxString);
    }

    public SortedMap<Long, Bin[]> getMap() {
        return this.map;
    }

    public TrendingRestInterface.ErrorBars getErrorBars() {
        return this.errorBars;
    }
}

