/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.trending;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.lsst.ccs.web.trending.ChannelTree;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ChannelTree {
    private final TreeNode root;
    private int nextHandle = 0;
    private final Map<Integer, TreeNode> nodeMap = new HashMap();

    private ChannelTree() {
        this.root = new TreeNode(this.nextHandle++);
        this.nodeMap.put(this.root.getHandle(), this.root);
    }

    ChannelTree(String message) {
        this.root = new TreeNode(this.nextHandle++);
        this.root.addChild(new TreeNode(this.nextHandle++, message));
    }

    ChannelTree(InputStream in) throws IOException {
        this();
        this.buildTree(in);
    }

    private void buildTree(InputStream in) throws IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(in);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("datachannels/datachannel");
            XPathExpression pathExpression = xpath.compile("path/pathelement");
            NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            for (int n = 0; n < nl.getLength(); ++n) {
                Node node = nl.item(n);
                node.getParentNode().removeChild(node);
                NodeList pathList = (NodeList)pathExpression.evaluate(node, XPathConstants.NODESET);
                ArrayList<String> path = new ArrayList<String>(pathList.getLength());
                for (int nn = 0; nn < pathList.getLength(); ++nn) {
                    path.add(pathList.item(nn).getTextContent());
                }
                String id = (String)xpath.evaluate("id", node, XPathConstants.STRING);
                this.addNode(id, path);
            }
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException x) {
            throw new IOException("Error parsing channel list", x);
        }
    }

    private void addNode(String id, List<String> path) {
        TreeNode node = this.root;
        for (String element : path) {
            TreeNode child = node.findChildByName(element);
            if (child == null) {
                child = new TreeNode(this.nextHandle++, element);
                node.addChild(child);
                this.nodeMap.put(child.getHandle(), child);
            }
            node = child;
        }
        node.setId(id);
    }

    TreeNode getRoot() {
        return this.root;
    }

    TreeNode findNode(Integer handle) {
        return (TreeNode)this.nodeMap.get(handle);
    }

    private void traverseTree(TreeNode start, List<String> initialPath, boolean visitAll, BiConsumer<List<String>, TreeNode> visitor) {
        Set children = start.getChildren();
        ArrayList<String> path = new ArrayList<String>(initialPath);
        if (start.getName() != null) {
            path.add(start.getName());
        }
        if (children.isEmpty()) {
            visitor.accept(path, start);
        } else {
            if (visitAll) {
                visitor.accept(path, start);
            }
            children.forEach(child -> this.traverseTree(child, path, visitAll, visitor));
        }
    }

    ChannelTree filter(Pattern pattern) {
        ChannelTree result = new ChannelTree();
        this.traverseTree(this.root, Collections.EMPTY_LIST, false, (path, node) -> {
            String fullPath = path.stream().collect(Collectors.joining("/"));
            if (pattern.matcher(fullPath).matches()) {
                result.addNode(node.getId(), path);
            }
        });
        return result;
    }

    ChannelTree flatten() {
        ChannelTree result = new ChannelTree();
        ArrayList suppressStart = new ArrayList();
        ArrayList suppressSize = new ArrayList();
        this.traverseTree(this.root, Collections.EMPTY_LIST, true, (path, node) -> {
            int index;
            if (path.size() == 0) {
                return;
            }
            for (index = suppressStart.size() - 1; index >= 0; --index) {
                if (path.size() > (Integer)suppressStart.get(index) + (Integer)suppressSize.get(index)) continue;
                suppressStart.remove(index);
                suppressSize.remove(index);
            }
            if (node.getChildren().size() == 1) {
                index = suppressStart.size() - 1;
                if (index >= 0 && (Integer)suppressStart.get(index) + (Integer)suppressSize.get(index) + 1 == path.size()) {
                    suppressSize.set(index, (Integer)suppressSize.get(index) + 1);
                } else {
                    suppressStart.add(path.size() - 1);
                    suppressSize.add(1);
                }
            } else if (node.getChildren().isEmpty()) {
                if (suppressStart.isEmpty()) {
                    result.addNode(node.getId(), path);
                } else {
                    ArrayList<String> newPath = new ArrayList<String>();
                    int index2 = 0;
                    int i = 0;
                    while (i < path.size()) {
                        if (index2 < suppressStart.size() && i == (Integer)suppressStart.get(index2)) {
                            newPath.add(String.join((CharSequence)"/", path.subList(i, i + (Integer)suppressSize.get(index2) + 1)));
                            i += (Integer)suppressSize.get(index2) + 1;
                            ++index2;
                            continue;
                        }
                        newPath.add((String)path.get(i));
                        ++i;
                    }
                    result.addNode(node.getId(), newPath);
                }
            }
        });
        return result;
    }

    void dump() {
        this.traverseTree(this.root, Collections.EMPTY_LIST, false, (path, node) -> System.out.printf("%s: %s\n", path, node.id));
    }
}

