/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.trending;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.web.trending.ChannelTree;

public class ChannelTreeTest {
    private static ChannelTree tree;

    @BeforeAll
    public static void setUpClass() throws Exception {
        try (InputStream in = ChannelTreeTest.class.getResourceAsStream("listchannels.xml");){
            Assertions.assertNotNull((Object)in);
            tree = new ChannelTree(in);
            Assertions.assertEquals((int)34, (int)tree.getRoot().getChildren().size());
        }
    }

    @AfterAll
    public static void tearDownClass() throws Exception {
    }

    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testReadChannels() throws IOException {
        Assertions.assertEquals((int)34, (int)tree.getRoot().getChildren().size());
    }

    @Test
    public void filterChannels() throws IOException {
        ChannelTree filtered = tree.filter(Pattern.compile("focal-plane/.*"));
        Assertions.assertEquals((int)1, (int)filtered.getRoot().getChildren().size());
    }

    @Test
    public void flattenChannels() throws IOException {
        ChannelTree filtered = tree.filter(Pattern.compile(".*/freememory", 2));
        ChannelTree flattened = filtered.flatten();
        Assertions.assertEquals((int)34, (int)flattened.getRoot().getChildren().size());
    }

    @Test
    public void flattenChannels2() throws IOException {
        ChannelTree filtered = tree.filter(Pattern.compile(".*/*memory", 2));
        ChannelTree flattened = filtered.flatten();
        Assertions.assertEquals((int)34, (int)flattened.getRoot().getChildren().size());
    }

    @Test
    public void flattenChannels3() throws IOException {
        ChannelTree filtered = tree.filter(Pattern.compile(".*/R34/.*/rds/.*", 2));
        ChannelTree flattened = filtered.flatten();
        Assertions.assertEquals((int)1, (int)flattened.getRoot().getChildren().size());
    }

    @Test
    public void flattenChannels4() throws IOException {
        ChannelTree filtered = tree.filter(Pattern.compile(".*/.*temp", 2));
        ChannelTree flattened = filtered.flatten();
        Assertions.assertEquals((int)5, (int)flattened.getRoot().getChildren().size());
    }
}

