/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.trending;

import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.lsst.ccs.web.trending.ChannelTree;
import org.lsst.ccs.web.trending.Globs;
import org.lsst.ccs.web.trending.MergedMap;
import org.lsst.ccs.web.trending.Site;
import org.lsst.ccs.web.trending.SiteATS;
import org.lsst.ccs.web.trending.SiteComCam;
import org.lsst.ccs.web.trending.SiteIR2;
import org.lsst.ccs.web.trending.SiteMainCamera;
import org.lsst.ccs.web.trending.TrendingRestInterface;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Path(value="/")
@Produces(value={"application/json"})
public class TrendingRestInterface {
    private static final Logger LOG = Logger.getLogger(TrendingRestInterface.class.getName());
    private static final Map<String, Site> sites = new HashMap();
    private final Site defaultSite;
    private static final Pattern SYNTAX_FILTER_PATTERN = Pattern.compile("(?:([a-z]+):)?(.*)");

    public TrendingRestInterface() throws IOException {
        String defaultSiteName = System.getProperty("org.lsst.ccs.web.trending.default.site", "ir2");
        this.defaultSite = this.getSiteForName(defaultSiteName);
        LOG.log(Level.INFO, "Created TrendingRestInterface with default site: {0}", this.defaultSite.getName());
    }

    private Site getSiteForName(String siteName) {
        Site site = this.defaultSite;
        if (!siteName.isEmpty() && (site = (Site)sites.get(siteName)) == null) {
            throw new RuntimeException("Unknown site " + siteName + ". Available sites are: " + sites.keySet());
        }
        return site;
    }

    @GET
    @Path(value="/channels")
    public Object channels(@QueryParam(value="id") Integer handle, @QueryParam(value="filter") String filter, @QueryParam(value="flatten") Boolean flatten, @QueryParam(value="refresh") Boolean refresh, @QueryParam(value="full") Boolean full) throws IOException {
        return this.channels("", handle, filter, flatten, refresh, full);
    }

    @GET
    @Path(value="/{site}/channels")
    public Object channels(@PathParam(value="site") String siteName, @QueryParam(value="id") Integer handle, @QueryParam(value="filter") String filter, @QueryParam(value="flatten") Boolean flatten, @QueryParam(value="refresh") Boolean refresh, @QueryParam(value="full") Boolean full) throws IOException {
        ChannelTree tree;
        Site site = this.getSiteForName(siteName);
        boolean fullTree = full == null ? false : full;
        boolean refreshTree = refresh == null ? false : refresh;
        ChannelTree channelTree = tree = fullTree ? site.getFullChannelTree(refreshTree) : site.getChannelTree(refreshTree);
        if (filter != null && !filter.isEmpty()) {
            try {
                Matcher matcher = SYNTAX_FILTER_PATTERN.matcher(filter);
                if (!matcher.matches()) {
                    throw new RuntimeException("Unknown syntax: " + filter);
                }
                String syntax = matcher.group(1);
                String regexp = matcher.group(2);
                if (syntax == null || syntax.isEmpty() || "glob".equals(syntax)) {
                    regexp = Globs.toUnixRegexPattern((String)regexp);
                } else if (!"regex".equals(syntax)) {
                    throw new RuntimeException("Unknown syntax: " + syntax);
                }
                tree = tree.filter(Pattern.compile(regexp, 2));
                if (flatten == null || flatten.booleanValue()) {
                    tree = tree.flatten();
                }
            }
            catch (RuntimeException x) {
                return new ChannelTree("Invalid filter: " + x.getMessage()).getRoot().getChildren();
            }
        }
        if (tree.getRoot().getChildren().isEmpty()) {
            return new ChannelTree("Filter returned no results").getRoot().getChildren();
        }
        if (handle == null) {
            return tree.getRoot().getChildren();
        }
        return tree.findNode(handle).getChildren();
    }

    @GET
    public Object trending(@QueryParam(value="key") List<String> keys, @QueryParam(value="period") String period, @QueryParam(value="t1") Long t1, @QueryParam(value="t2") Long t2, @QueryParam(value="n") Integer nBins, @QueryParam(value="flavor") Flavor flavor, @QueryParam(value="errorBars") ErrorBars errorBars) throws IOException {
        return this.trending("", keys, period, t1, t2, nBins, flavor, errorBars);
    }

    @GET
    @Path(value="{site}")
    public Object trending(@PathParam(value="site") String siteName, @QueryParam(value="key") List<String> keys, @QueryParam(value="period") String period, @QueryParam(value="t1") Long t1, @QueryParam(value="t2") Long t2, @QueryParam(value="n") Integer nBins, @QueryParam(value="flavor") Flavor flavor, @QueryParam(value="errorBars") ErrorBars errorBars) throws IOException {
        Site site = this.getSiteForName(siteName);
        long now = System.currentTimeMillis();
        long delta = 3600000L;
        if (period != null) {
            delta = 43200000L;
        }
        if (t1 == null) {
            t1 = now - delta;
        }
        if (t2 == null) {
            t2 = now;
        }
        if (nBins == null) {
            nBins = 100;
        }
        if (flavor == null) {
            flavor = Flavor.STAT;
        }
        if (errorBars == null) {
            errorBars = ErrorBars.NONE;
        }
        TrendingMetaData meta = new TrendingMetaData(errorBars, nBins.intValue(), t1.longValue(), t2.longValue(), flavor);
        MergedMap merged = new MergedMap(keys.size(), errorBars);
        StringBuilder allKeys = new StringBuilder();
        for (String key : keys) {
            allKeys.append("id=").append(key).append('&');
        }
        String dataURL = String.format("data/?%st1=%s&t2=%s&n=%s&flavor=%s", allKeys, t1, t2, nBins, flavor.toString().toLowerCase());
        LOG.log(Level.INFO, "Reading: {0}", dataURL);
        try (InputStream in = site.openURL(dataURL);){
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            1 handler = new /* Unavailable Anonymous Inner Class!! */;
            saxParser.parse(in, (DefaultHandler)handler, "data");
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new IOException("Error processing restful data from: " + dataURL, ex);
        }
        return new TrendingResult(meta, merged);
    }

    static {
        try {
            Site ir2 = SiteIR2.create();
            sites.put(ir2.getName(), ir2);
        }
        catch (JSchException | RuntimeException | MalformedURLException | UnknownHostException ex) {
            LOG.log(Level.SEVERE, "Failed to initialize sites", ex);
        }
        try {
            Site ats = SiteATS.create();
            sites.put(ats.getName(), ats);
        }
        catch (JSchException | RuntimeException | MalformedURLException ex) {
            LOG.log(Level.SEVERE, "Failed to initialize sites", ex);
        }
        try {
            Site comcam = SiteComCam.create();
            sites.put(comcam.getName(), comcam);
        }
        catch (JSchException | RuntimeException | MalformedURLException ex) {
            LOG.log(Level.SEVERE, "Failed to initialize sites", ex);
        }
        try {
            Site maincamera = SiteMainCamera.create();
            sites.put(maincamera.getName(), maincamera);
        }
        catch (JSchException | RuntimeException | MalformedURLException ex) {
            LOG.log(Level.SEVERE, "Failed to initialize sites", ex);
        }
    }
}

