/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.trending;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.web.trending.ChannelTree;
import org.lsst.ccs.web.trending.Site;

public class Site
implements AutoCloseable {
    private final String name;
    private final boolean useSSH;
    private final URL restURL;
    private final String sshUsername;
    private final String sshHost;
    private final File sshKey;
    private final String sshKeyPassword;
    private volatile Session session;
    private volatile URL tunnelURL;
    private final AtomicReference<ChannelTree> channelTree = new AtomicReference();
    private final AtomicBoolean channelTreeInitialized = new AtomicBoolean(false);
    private final CountDownLatch channelTreeInitCompleteLatch = new CountDownLatch(1);
    private final AtomicReference<ChannelTree> fullChannelTree = new AtomicReference();
    private final AtomicBoolean fullChannelTreeInitialized = new AtomicBoolean(false);
    private final CountDownLatch fullChannelTreeInitCompleteLatch = new CountDownLatch(1);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Logger LOG = Logger.getLogger(Site.class.getName());
    private static final int SSH_TIMEOUT = 10000;
    private static final int SSH_RETRIES = 2;
    private int sshTimeout = 10000;
    private int sshRetries = 2;

    public Site(Properties properties) throws MalformedURLException, JSchException {
        this.name = properties.getProperty("name");
        this.useSSH = Boolean.parseBoolean(properties.getProperty("useSSH", "false"));
        this.restURL = new URL(properties.getProperty("restURL"));
        if (this.useSSH) {
            this.sshUsername = properties.getProperty("ssh.user");
            this.sshHost = properties.getProperty("ssh.host");
            this.sshKey = new File(properties.getProperty("ssh.key"));
            if (!this.sshKey.canRead()) {
                throw new RuntimeException("Invalid ssh key " + properties.getProperty("ssh.key"));
            }
            this.sshKeyPassword = properties.getProperty("ssh.key.password");
        } else {
            this.sshKeyPassword = null;
            this.sshHost = null;
            this.sshUsername = null;
            this.sshKey = null;
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public URL getTunnelURL() {
        return this.tunnelURL;
    }

    public void setTunnelURL(URL tunnelURL) {
        this.tunnelURL = tunnelURL;
    }

    public int getSSHTimeout() {
        return this.sshTimeout;
    }

    public final void setSSHTimeout(int sshTimeout) {
        this.sshTimeout = sshTimeout;
    }

    public int getSSHRetries() {
        return this.sshRetries;
    }

    public final void setSSHRetries(int sshRetries) {
        this.sshRetries = sshRetries;
    }

    private synchronized void establishConnection() throws MalformedURLException, IOException {
        if (this.useSSH && (this.session == null || !this.session.isConnected())) {
            try {
                JSch jsch = new JSch();
                jsch.addIdentity(this.sshKey.getAbsolutePath(), this.sshKeyPassword);
                this.session = jsch.getSession(this.sshUsername, this.sshHost);
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                config.put("PreferredAuthentications", "publickey");
                this.session.setConfig(config);
                this.session.setDaemonThread(true);
                this.session.connect(5000);
                int port = this.session.setPortForwardingL(null, 0, this.restURL.getHost(), this.restURL.getPort());
                this.tunnelURL = new URL("http", "localhost", port, this.restURL.getPath());
                LOG.log(Level.INFO, "Tunnel to {0} for site {1} opened {2}", new Object[]{this.sshHost, this.name, this.tunnelURL});
            }
            catch (JSchException ex) {
                throw new IOException("Error opening tunnel ", ex);
            }
        }
    }

    public InputStream openURL(String relativePath) throws MalformedURLException, IOException {
        if (!this.useSSH) {
            URL url = new URL(this.restURL, relativePath);
            return url.openStream();
        }
        IOException cause = null;
        for (int i = 0; i < this.sshRetries; ++i) {
            this.establishConnection();
            URL url = new URL(this.tunnelURL, relativePath);
            try {
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(this.sshTimeout);
                connection.setReadTimeout(this.sshTimeout);
                return connection.getInputStream();
            }
            catch (IOException x) {
                cause = x;
                LOG.log(Level.WARNING, "Failed to connect via ssh to " + url + " (attempt " + i + ")", x);
                this.session.disconnect();
                continue;
            }
        }
        throw new IOException("Unable to establish ssh connection after " + this.sshRetries + " retries", cause);
    }

    @Override
    public void close() {
        if (this.useSSH && this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
    }

    ChannelTree getChannelTree(boolean refresh) throws IOException {
        1 readChannelTree = new /* Unavailable Anonymous Inner Class!! */;
        if (refresh || !this.channelTreeInitialized.getAndSet(true)) {
            try {
                readChannelTree.run();
            }
            finally {
                this.channelTreeInitCompleteLatch.countDown();
            }
        }
        try {
            this.channelTreeInitCompleteLatch.await();
        }
        catch (InterruptedException x) {
            throw new InterruptedIOException();
        }
        ChannelTree result = (ChannelTree)this.channelTree.get();
        if (result == null) {
            throw new IOException("Channel tree unavailable");
        }
        return result;
    }

    ChannelTree getFullChannelTree(boolean refresh) throws IOException {
        2 readFullChannelTree = new /* Unavailable Anonymous Inner Class!! */;
        if (refresh || !this.fullChannelTreeInitialized.getAndSet(true)) {
            try {
                readFullChannelTree.run();
            }
            finally {
                this.fullChannelTreeInitCompleteLatch.countDown();
            }
        }
        try {
            this.fullChannelTreeInitCompleteLatch.await();
        }
        catch (InterruptedException x) {
            throw new InterruptedIOException();
        }
        ChannelTree result = (ChannelTree)this.fullChannelTree.get();
        if (result == null) {
            throw new IOException("Full channel tree unavailable");
        }
        return result;
    }

    String getName() {
        return this.name;
    }

    static /* synthetic */ AtomicReference access$000(Site x0) {
        return x0.channelTree;
    }

    static /* synthetic */ String access$100(Site x0) {
        return x0.name;
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }

    static /* synthetic */ ScheduledExecutorService access$300(Site x0) {
        return x0.scheduler;
    }

    static /* synthetic */ AtomicReference access$400(Site x0) {
        return x0.fullChannelTree;
    }
}

