/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.java;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.graphicsio.java.JAVAGraphics2D;

public class JAVAExportFileType
extends AbstractExportFileType {
    public String getDescription() {
        return "Java Source File (for Testing)";
    }

    public String[] getExtensions() {
        return new String[]{"java"};
    }

    public String[] getMIMETypes() {
        return new String[]{"application/java"};
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public VectorGraphics getGraphics(File file, Component target) throws IOException {
        return new JAVAGraphics2D(file, target);
    }

    public VectorGraphics getGraphics(File file, Dimension dimension) throws IOException {
        return new JAVAGraphics2D(file, dimension);
    }

    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, JAVAGraphics2D.getDefaultProperties());
        OptionPanel optionsPanel = new OptionPanel();
        OptionPanel imagePanel = new OptionPanel("Images");
        optionsPanel.add("0 0 [5 5 5 5] wt", (Component)imagePanel);
        OptionCheckBox embedOptionCheckBox = new OptionCheckBox((Properties)options, JAVAGraphics2D.EMBED_IMAGES, "Embed imagePanel as byte[]");
        imagePanel.add("0 * * 1 [5 15 5 15] w", (Component)embedOptionCheckBox);
        OptionCheckBox pathOptionCheckBox = new OptionCheckBox((Properties)options, JAVAGraphics2D.COMPLETE_IMAGE_PATHS, "Write complete path to image");
        imagePanel.add("0 * * 1 [5 15 5 15] w", (Component)pathOptionCheckBox);
        embedOptionCheckBox.disables((Component)pathOptionCheckBox);
        optionsPanel.add("0 * wh", (Component)new JLabel());
        return optionsPanel;
    }

    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new JAVAGraphics2D(os, target);
    }

    public VectorGraphics getGraphics(OutputStream os, Dimension dimension) throws IOException {
        return new JAVAGraphics2D(os, dimension);
    }
}

