/*
 * Decompiled with CFR 0.152.
 */
package org.opensplice.dds.dcps;

import DDS.ContentFilteredTopic;
import DDS.DataReader;
import DDS.DataReaderQos;
import DDS.DataWriter;
import DDS.DomainParticipant;
import DDS.DomainParticipantFactory;
import DDS.DomainParticipantListener;
import DDS.DomainParticipantQos;
import DDS.DomainParticipantQosHolder;
import DDS.DurabilityQosPolicyKind;
import DDS.Duration_t;
import DDS.ExtDomainParticipantListener;
import DDS.HistoryQosPolicyKind;
import DDS.InconsistentTopicStatus;
import DDS.InstanceHandleSeqHolder;
import DDS.LivelinessChangedStatus;
import DDS.LivelinessLostStatus;
import DDS.MainClassName;
import DDS.MultiTopic;
import DDS.OfferedDeadlineMissedStatus;
import DDS.OfferedIncompatibleQosStatus;
import DDS.PARTICIPANT_QOS_DEFAULT;
import DDS.PUBLISHER_QOS_DEFAULT;
import DDS.ParticipantBuiltinTopicDataDataReaderImpl;
import DDS.ParticipantBuiltinTopicDataHolder;
import DDS.ParticipantBuiltinTopicDataSeqHolder;
import DDS.PresentationQosPolicyAccessScopeKind;
import DDS.Property;
import DDS.PropertyHolder;
import DDS.PublicationMatchedStatus;
import DDS.Publisher;
import DDS.PublisherListener;
import DDS.PublisherQos;
import DDS.PublisherQosHolder;
import DDS.ReliabilityQosPolicyKind;
import DDS.RequestedDeadlineMissedStatus;
import DDS.RequestedIncompatibleQosStatus;
import DDS.SUBSCRIBER_QOS_DEFAULT;
import DDS.SampleInfoSeqHolder;
import DDS.SampleLostStatus;
import DDS.SampleRejectedStatus;
import DDS.SchedulingQosPolicy;
import DDS.SchedulingQosPolicyHolder;
import DDS.Subscriber;
import DDS.SubscriberListener;
import DDS.SubscriberQos;
import DDS.SubscriberQosHolder;
import DDS.SubscriptionMatchedStatus;
import DDS.TOPIC_QOS_DEFAULT;
import DDS.Time_tHolder;
import DDS.Topic;
import DDS.TopicBuiltinTopicDataDataReaderImpl;
import DDS.TopicBuiltinTopicDataHolder;
import DDS.TopicBuiltinTopicDataSeqHolder;
import DDS.TopicDescription;
import DDS.TopicListener;
import DDS.TopicQos;
import DDS.TopicQosHolder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.opensplice.dds.dcps.ContentFilteredTopicImpl;
import org.opensplice.dds.dcps.DataReaderImpl;
import org.opensplice.dds.dcps.DomainParticipantBase;
import org.opensplice.dds.dcps.Event;
import org.opensplice.dds.dcps.ListenerDispatcher;
import org.opensplice.dds.dcps.ObjectImpl;
import org.opensplice.dds.dcps.PublisherImpl;
import org.opensplice.dds.dcps.ReportStack;
import org.opensplice.dds.dcps.SubscriberImpl;
import org.opensplice.dds.dcps.TopicImpl;
import org.opensplice.dds.dcps.TypeSupportImpl;
import org.opensplice.dds.dcps.Utilities;

public class DomainParticipantImpl
extends DomainParticipantBase
implements DomainParticipant {
    private static final long serialVersionUID = 4658964521910484015L;
    private DomainParticipantListener listener = null;
    private TopicQos defaultTopicQos = Utilities.defaultTopicQos;
    private PublisherQos defaultPublisherQos = Utilities.defaultPublisherQos;
    private SubscriberQos defaultSubscriberQos = Utilities.defaultSubscriberQos;
    private SchedulingQosPolicy listener_scheduling;
    private String baseName;
    private final Map<String, TypeSupportImpl> typeSupports;
    private final Set<ContentFilteredTopicImpl> contentFilteredTopics;
    private final Set<TopicImpl> topics;
    private final Set<PublisherImpl> publishers;
    private final Set<SubscriberImpl> subscribers;
    private final Set<TopicImpl> builtintopics;
    private SubscriberImpl builtinSubscriber;
    private long participantDataCopyCache;
    private long topicBuiltinTopicDataCopyCache;
    private boolean factoryAutoEnable;
    private String[][] builtinTopicNames;
    private int listenerInterest;

    private boolean isBuiltinTopic(String topicName) {
        for (int i = 0; i < this.builtinTopicNames.length; ++i) {
            if (!this.builtinTopicNames[i][0].equals(topicName)) continue;
            return true;
        }
        return false;
    }

    protected DomainParticipantImpl() {
        this.listener_scheduling = Utilities.defaultDomainParticipantQos.listener_scheduling;
        this.typeSupports = new HashMap<String, TypeSupportImpl>();
        this.contentFilteredTopics = new HashSet<ContentFilteredTopicImpl>();
        this.topics = new HashSet<TopicImpl>();
        this.publishers = new HashSet<PublisherImpl>();
        this.subscribers = new HashSet<SubscriberImpl>();
        this.builtintopics = new HashSet<TopicImpl>();
        this.builtinSubscriber = null;
        this.factoryAutoEnable = false;
        this.builtinTopicNames = new String[][]{{"DCPSParticipant", "DDS::ParticipantBuiltinTopicData"}, {"DCPSTopic", "DDS::TopicBuiltinTopicData"}, {"DCPSPublication", "DDS::PublicationBuiltinTopicData"}, {"DCPSSubscription", "DDS::SubscriptionBuiltinTopicData"}, {"CMParticipant", "DDS::CMParticipantBuiltinTopicData"}, {"CMPublisher", "DDS::CMPublisherBuiltinTopicData"}, {"CMSubscriber", "DDS::CMSubscriberBuiltinTopicData"}, {"CMDataWriter", "DDS::CMDataWriterBuiltinTopicData"}, {"CMDataReader", "DDS::CMDataReaderBuiltinTopicData"}, {"DCPSType", "DDS::TypeBuiltinTopicData"}};
        this.listenerInterest = 0;
    }

    protected int init(String name, int domainId, DomainParticipantQos a_qos) {
        int result = 0;
        ListenerDispatcher dispatcher = null;
        long uParticipant = this.jniDomainParticipantNew(name, domainId, a_qos);
        if (uParticipant != 0L) {
            this.set_user_object(uParticipant);
            this.setDomainId(this.jniGetDomainId(uParticipant));
            this.baseName = name.replace(" " + MainClassName.getProcessId(), "");
            this.factoryAutoEnable = a_qos.entity_factory.autoenable_created_entities;
            dispatcher = new ListenerDispatcher(uParticipant, a_qos.listener_scheduling);
            result = this.set_dispatcher(dispatcher);
        } else {
            result = 1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deinit() {
        int result = 0;
        ListenerDispatcher dispatcher = null;
        DomainParticipantImpl domainParticipantImpl = this;
        synchronized (domainParticipantImpl) {
            long uParticipant = this.get_user_object();
            if (uParticipant != 0L) {
                if (this.topics.size() > this.builtintopics.size()) {
                    result = 4;
                    ReportStack.report(result, "DomainParticipant still contains '" + this.topics.size() + "' Topic entities.");
                } else if (this.publishers.size() != 0) {
                    result = 4;
                    ReportStack.report(result, "DomainParticipant still contains '" + this.publishers.size() + "' Publisher entities.");
                } else if (this.subscribers.size() != 0) {
                    result = 4;
                    ReportStack.report(result, "DomainParticipant still contains '" + this.subscribers.size() + "' Subscriber entities.");
                } else if (this.contentFilteredTopics.size() != 0) {
                    result = 4;
                    ReportStack.report(result, "DomainParticipant still contains '" + this.contentFilteredTopics.size() + "' ContentFilteredTopic entities.");
                } else {
                    if (this.listener != null) {
                        result = this.set_listener(this.listener, 0);
                    }
                    if (result == 0 && (result = this.disable_callbacks()) == 0 && (result = this.delete_builtin_subscriber()) == 0) {
                        dispatcher = this.get_dispatcher();
                        if (dispatcher != null && (result = this.set_dispatcher(null)) == 0) {
                            result = dispatcher.deinit();
                        }
                        if (result == 0) {
                            result = this.detach_statuscondition();
                        }
                        if (result == 0) {
                            this.builtintopics.clear();
                            result = this.jniDomainParticipantFree(uParticipant);
                            if (result == 0) {
                                result = super.deinit();
                            }
                        }
                    }
                }
            } else {
                result = 9;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(TypeSupportImpl ts, String alias_name) {
        boolean result;
        DomainParticipantImpl domainParticipantImpl = this;
        synchronized (domainParticipantImpl) {
            if (this.typeSupports.containsKey(alias_name)) {
                result = false;
            } else {
                this.typeSupports.put(alias_name, ts);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String alias_name) {
        DomainParticipantImpl domainParticipantImpl = this;
        synchronized (domainParticipantImpl) {
            this.typeSupports.remove(alias_name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeSupportImpl lookup_typeSupport(String name) {
        DomainParticipantImpl domainParticipantImpl = this;
        synchronized (domainParticipantImpl) {
            return this.typeSupports.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Publisher create_publisher(PublisherQos qos, PublisherListener a_listener, int mask) {
        int result = 0;
        PublisherImpl pub = null;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos != PUBLISHER_QOS_DEFAULT.value) {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            DomainParticipantImpl domainParticipantImpl = this;
            synchronized (domainParticipantImpl) {
                if (qos == PUBLISHER_QOS_DEFAULT.value) {
                    qos = this.defaultPublisherQos;
                }
                if ((result = (pub = new PublisherImpl()).init(this, "publisher <" + this.baseName + ">", qos)) == 0) {
                    this.publishers.add(pub);
                    ListenerDispatcher dispatcher = this.get_dispatcher();
                    result = pub.set_dispatcher(dispatcher);
                } else {
                    pub = null;
                }
                if (result == 0) {
                    result = pub.set_listener(a_listener, mask);
                }
                if (result == 0 && this.factoryAutoEnable && this.is_enabled()) {
                    result = pub.enable();
                }
                if (result != 0 && pub != null) {
                    this.delete_publisher(pub);
                    pub = null;
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return pub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_publisher(Publisher pub) {
        int result = 0;
        ReportStack.start();
        if (pub == null) {
            result = 3;
            ReportStack.report(result, "publisher 'null' is invalid.");
        } else {
            DomainParticipantImpl domainParticipantImpl = this;
            synchronized (domainParticipantImpl) {
                PublisherImpl p = (PublisherImpl)pub;
                if (this.publishers.remove(p)) {
                    result = p.deinit();
                    if (result != 0) {
                        this.publishers.add(p);
                    }
                } else if (p.get_user_object() == 0L) {
                    result = 9;
                } else {
                    result = 4;
                    ReportStack.report(result, "Publisher not created by DomainParticipant.");
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscriber create_subscriber(SubscriberQos qos, SubscriberListener a_listener, int mask) {
        int result = 0;
        SubscriberImpl sub = null;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos != SUBSCRIBER_QOS_DEFAULT.value) {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            DomainParticipantImpl domainParticipantImpl = this;
            synchronized (domainParticipantImpl) {
                if (qos == SUBSCRIBER_QOS_DEFAULT.value) {
                    qos = this.defaultSubscriberQos;
                }
                if ((result = (sub = new SubscriberImpl()).init(this, "subscriber <" + this.baseName + ">", qos)) == 0) {
                    this.subscribers.add(sub);
                    ListenerDispatcher dispatcher = this.get_dispatcher();
                    result = sub.set_dispatcher(dispatcher);
                } else {
                    sub = null;
                }
                if (result == 0) {
                    result = sub.set_listener(a_listener, mask);
                }
                if (result == 0 && this.factoryAutoEnable && this.is_enabled() && (qos.presentation.access_scope != PresentationQosPolicyAccessScopeKind.GROUP_PRESENTATION_QOS || !qos.presentation.coherent_access)) {
                    result = sub.enable();
                }
                if (result != 0 && sub != null) {
                    this.delete_subscriber(sub);
                    sub = null;
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_subscriber(Subscriber sub) {
        int result = 0;
        ReportStack.start();
        if (sub == null) {
            result = 3;
            ReportStack.report(result, "subscriber 'null' is invalid.");
        } else {
            DomainParticipantImpl domainParticipantImpl = this;
            synchronized (domainParticipantImpl) {
                SubscriberImpl s = (SubscriberImpl)sub;
                if (s.equals(this.builtinSubscriber)) {
                    result = this.delete_builtin_subscriber();
                } else if (this.subscribers.remove(s)) {
                    result = s.deinit();
                    if (result != 0) {
                        this.subscribers.add(s);
                    }
                } else if (s.get_user_object() == 0L) {
                    result = 9;
                } else {
                    result = 4;
                    ReportStack.report(result, "Subscriber not created by DomainParticipant.");
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    private int create_builtin_subscriber() {
        int result = 0;
        TopicQos topicQos = new TopicQos();
        topicQos = Utilities.deepCopy(Utilities.defaultTopicQos);
        topicQos.durability.kind = DurabilityQosPolicyKind.TRANSIENT_DURABILITY_QOS;
        topicQos.reliability.kind = ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS;
        topicQos.history.kind = HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS;
        topicQos.history.depth = -1;
        SubscriberQos subscriberQos = new SubscriberQos();
        subscriberQos = Utilities.deepCopy(Utilities.defaultSubscriberQos);
        subscriberQos.partition.name = new String[1];
        subscriberQos.partition.name[0] = new String("__BUILT-IN PARTITION__");
        subscriberQos.presentation.access_scope = PresentationQosPolicyAccessScopeKind.TOPIC_PRESENTATION_QOS;
        DataReaderQos readerQos = new DataReaderQos();
        readerQos = Utilities.deepCopy(Utilities.defaultDataReaderQos);
        readerQos.durability.kind = DurabilityQosPolicyKind.TRANSIENT_DURABILITY_QOS;
        readerQos.reliability.kind = ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS;
        this.builtinSubscriber = new SubscriberImpl();
        result = this.builtinSubscriber.init(this, "BuiltinSubscriber", subscriberQos);
        if (result == 0) {
            if (this.is_enabled()) {
                result = this.builtinSubscriber.enable();
            }
            for (int i = 0; i < this.builtinTopicNames.length && result == 0; ++i) {
                Topic topic = this.create_topic(this.builtinTopicNames[i][0], this.builtinTopicNames[i][1], topicQos, null, 0);
                if (topic != null) {
                    this.builtintopics.add((TopicImpl)topic);
                    DataReader reader = this.builtinSubscriber.create_datareader(topic, readerQos, null, 0);
                    if (reader != null) continue;
                    this.delete_builtin_subscriber();
                    ReportStack.report(result, "Failed to initialize built-in DataReader for Topic '" + this.builtinTopicNames[i][0] + "'.");
                    result = 1;
                    continue;
                }
                this.delete_builtin_subscriber();
                ReportStack.report(result, "Failed to initialize built-in Topic '" + this.builtinTopicNames[i][0] + "'.");
                result = 1;
            }
        } else {
            this.builtinSubscriber = null;
        }
        return result;
    }

    private int delete_builtin_subscriber() {
        int endResult = 0;
        if (this.builtinSubscriber != null) {
            int result = this.builtinSubscriber.delete_contained_entities();
            if (result == 0) {
                result = this.builtinSubscriber.deinit();
                if (result == 0 || result == 9) {
                    this.builtinSubscriber = null;
                }
                if (result != 0) {
                    ReportStack.report(result, "Deletion of built-in Subscriber failed.");
                }
            } else {
                if (result == 9) {
                    this.builtinSubscriber = null;
                }
                ReportStack.report(result, "delete_contained_entities failed on built-in Subscriber.");
            }
            if (endResult == 0) {
                endResult = result;
            }
            Iterator<TopicImpl> bti = this.builtintopics.iterator();
            while (bti.hasNext()) {
                TopicImpl t = bti.next();
                result = t.deinit();
                if (result == 0 || result == 9) {
                    bti.remove();
                    this.topics.remove(t);
                }
                if (result == 0) continue;
                ReportStack.report(result, "Deletion of Topic contained in built-in Subscriber failed.");
                if (endResult != 0) continue;
                endResult = result;
            }
        }
        return endResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscriber get_builtin_subscriber() {
        int result = 0;
        SubscriberImpl sub = null;
        ReportStack.start();
        DomainParticipantImpl domainParticipantImpl = this;
        synchronized (domainParticipantImpl) {
            if (this.is_enabled()) {
                if (this.builtinSubscriber == null) {
                    result = this.create_builtin_subscriber();
                }
                if (result == 0) {
                    sub = this.builtinSubscriber;
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Topic create_topic(String topic_name, String type_name, TopicQos qos, TopicListener a_listener, int mask) {
        TopicImpl topic = null;
        int result = 0;
        ReportStack.start();
        if (topic_name == null) {
            result = 3;
            ReportStack.report(result, "topic_name 'null' is invalid.");
        } else if (type_name == null) {
            result = 3;
            ReportStack.report(result, "type_name 'null' is invalid.");
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            topic = new TopicImpl();
            DomainParticipantImpl domainParticipantImpl = this;
            synchronized (domainParticipantImpl) {
                if (qos == TOPIC_QOS_DEFAULT.value) {
                    qos = this.defaultTopicQos;
                }
                if ((result = topic.init(this, topic_name, type_name, qos)) == 0) {
                    this.topics.add(topic);
                    ListenerDispatcher dispatcher = this.get_dispatcher();
                    result = topic.set_dispatcher(dispatcher);
                } else {
                    topic = null;
                }
                if (result == 0) {
                    result = topic.set_listener(a_listener, mask);
                }
                if (result == 0) {
                    if (this.factoryAutoEnable && this.is_enabled()) {
                        result = topic.enable();
                    }
                    topic.set_participant_listener_mask(this.listenerInterest);
                }
                if (result != 0 && topic != null) {
                    this.delete_topic(topic);
                    topic = null;
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_topic(Topic topic) {
        int result = 0;
        ReportStack.start();
        if (topic == null) {
            result = 3;
            ReportStack.report(result, "topic 'null' is invalid.");
        } else {
            DomainParticipantImpl domainParticipantImpl = this;
            synchronized (domainParticipantImpl) {
                TopicImpl t = (TopicImpl)topic;
                if (this.topics.remove(t)) {
                    result = t.deinit();
                    if (result != 0) {
                        this.topics.add(t);
                    } else {
                        this.builtintopics.remove(t);
                    }
                } else if (t.get_user_object() == 0L) {
                    result = 9;
                } else {
                    result = 4;
                    ReportStack.report(result, "Topic not created by DomainParticipant.");
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Topic find_topic(String topic_name, Duration_t timeout) {
        int result = 0;
        Topic topic = null;
        TopicImpl found = null;
        TypeSupportImpl type_support = null;
        long uParticipant = 0L;
        long uTopic = 0L;
        ReportStack.start();
        if (topic_name == null) {
            result = 3;
            ReportStack.report(result, "topic_name 'null' is invalid.");
        } else if (topic_name.contains("*") || topic_name.contains("?")) {
            result = 3;
            ReportStack.report(result, "topic_name '" + topic_name + "' is invalid.");
        } else {
            result = Utilities.checkDuration(timeout);
        }
        if (result == 0) {
            DomainParticipantImpl domainParticipantImpl = this;
            synchronized (domainParticipantImpl) {
                uParticipant = this.get_user_object();
                if (uParticipant != 0L) {
                    for (TopicImpl t : this.topics) {
                        if (!t.get_name().equals(topic_name)) continue;
                        found = t;
                    }
                    if (found == null && this.isBuiltinTopic(topic_name) && (result = this.create_builtin_subscriber()) == 0) {
                        for (TopicImpl t : this.topics) {
                            if (!t.get_name().equals(topic_name)) continue;
                            found = t;
                            break;
                        }
                    }
                    if (found != null) {
                        TopicQosHolder qos = new TopicQosHolder();
                        found.get_qos(qos);
                        String type_alias = found.get_type_name();
                        for (String alias : this.typeSupports.keySet()) {
                            TypeSupportImpl tsp = this.typeSupports.get(alias);
                            if (tsp != found.get_typesupport()) continue;
                            type_alias = alias;
                            break;
                        }
                        if ((topic = this.create_topic(topic_name, type_alias, qos.value, null, 0)) != null) {
                            this.topics.add((TopicImpl)topic);
                        }
                    } else {
                        uTopic = this.jniFindTopic(uParticipant, topic_name, timeout);
                        if (uTopic != 0L) {
                            TopicImpl topicImpl = new TopicImpl();
                            result = topicImpl.clone(uTopic, this, type_support);
                            if (result == 0) {
                                this.topics.add(topicImpl);
                                topic = topicImpl;
                            }
                        } else {
                            result = 4;
                            ReportStack.report(result, "Failed to resolve Topic '" + topic_name + "'.");
                        }
                    }
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TopicDescription lookup_topicdescription(String name) {
        int result = 0;
        ObjectImpl found = null;
        ReportStack.start();
        if (name == null) {
            result = 3;
            ReportStack.report(result, "name 'null' is invalid.");
        } else {
            DomainParticipantImpl domainParticipantImpl = this;
            synchronized (domainParticipantImpl) {
                for (TopicImpl topic : this.topics) {
                    if (!topic.get_name().equals(name)) continue;
                    found = topic;
                    break;
                }
                if (found == null && this.isBuiltinTopic(name) && (result = this.create_builtin_subscriber()) == 0) {
                    for (TopicImpl topic : this.topics) {
                        if (!topic.get_name().equals(name)) continue;
                        found = topic;
                        break;
                    }
                }
                if (found == null) {
                    for (ContentFilteredTopicImpl cft : this.contentFilteredTopics) {
                        if (!cft.get_name().equals(name)) continue;
                        found = cft;
                        break;
                    }
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentFilteredTopic create_contentfilteredtopic(String name, Topic related_topic, String filter_expression, String[] expression_parameters) {
        int result = 0;
        ContentFilteredTopicImpl topic = null;
        ReportStack.start();
        if (name == null) {
            result = 3;
            ReportStack.report(result, "name 'null' is invalid.");
        } else if (related_topic == null) {
            result = 3;
            ReportStack.report(result, "related_topic 'null' is invalid.");
        } else if (filter_expression == null) {
            result = 3;
            ReportStack.report(result, "filter_expression 'null' is invalid.");
        } else {
            DomainParticipantImpl domainParticipantImpl = this;
            synchronized (domainParticipantImpl) {
                long uParticipant = this.get_user_object();
                if (uParticipant != 0L) {
                    topic = new ContentFilteredTopicImpl();
                    result = topic.init(this, name, (TopicImpl)related_topic, filter_expression, expression_parameters);
                    if (result == 0) {
                        this.contentFilteredTopics.add(topic);
                    } else {
                        topic = null;
                    }
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_contentfilteredtopic(ContentFilteredTopic topic) {
        int result = 0;
        ReportStack.start();
        if (topic == null) {
            result = 3;
            ReportStack.report(result, "topic 'null' is invalid.");
        } else {
            DomainParticipantImpl domainParticipantImpl = this;
            synchronized (domainParticipantImpl) {
                ContentFilteredTopicImpl cft = (ContentFilteredTopicImpl)topic;
                long uParticipant = this.get_user_object();
                if (uParticipant != 0L) {
                    if (this.contentFilteredTopics.remove(cft)) {
                        result = cft.deinit();
                        if (result != 0) {
                            this.contentFilteredTopics.add(cft);
                        }
                    } else {
                        result = 4;
                        ReportStack.report(result, "ContentFilteredTopic not registered to DomainParticipant.");
                    }
                } else {
                    result = 9;
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public MultiTopic create_multitopic(String name, String type_name, String subscription_expression, String[] expression_parameters) {
        ReportStack.start();
        ReportStack.report(2, "create_multitopic is not yet supported.");
        ReportStack.flush(this, true);
        return null;
    }

    @Override
    public int delete_multitopic(MultiTopic a_multitopic) {
        int result = 2;
        ReportStack.start();
        ReportStack.report(result, "delete_multitopic is not yet supported.");
        ReportStack.flush(this, true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_contained_entities() {
        int endResult = 0;
        ReportStack.start();
        DomainParticipantImpl domainParticipantImpl = this;
        synchronized (domainParticipantImpl) {
            int result;
            Iterator<PublisherImpl> ip = this.publishers.iterator();
            while (ip.hasNext()) {
                PublisherImpl p = ip.next();
                result = p.delete_contained_entities();
                if (result == 0) {
                    result = p.deinit();
                    if (result == 0 || result == 9) {
                        ip.remove();
                    }
                    if (result != 0) {
                        ReportStack.report(result, "Deletion of Publisher contained in DomainParticipant failed.");
                    }
                } else {
                    if (result == 9) {
                        ip.remove();
                    }
                    ReportStack.report(result, "delete_contained_entities failed on Publisher contained in DomainParticipant.");
                }
                if (endResult != 0) continue;
                endResult = result;
            }
            Iterator<SubscriberImpl> is = this.subscribers.iterator();
            while (is.hasNext()) {
                SubscriberImpl s = is.next();
                result = s.delete_contained_entities();
                if (result == 0) {
                    result = s.deinit();
                    if (result == 0 || result == 9) {
                        is.remove();
                    }
                    if (result != 0) {
                        ReportStack.report(result, "Deletion of Subscriber contained in DomainParticipant failed.");
                    }
                } else {
                    if (result == 9) {
                        is.remove();
                    }
                    ReportStack.report(result, "delete_contained_entities failed on Subscriber contained in DomainParticipant.");
                }
                if (endResult != 0) continue;
                endResult = result;
            }
            result = this.delete_builtin_subscriber();
            if (endResult == 0) {
                endResult = result;
            }
            Iterator<ContentFilteredTopicImpl> ict = this.contentFilteredTopics.iterator();
            while (ict.hasNext()) {
                result = ict.next().deinit();
                if (result == 0 || result == 9) {
                    ict.remove();
                }
                if (result == 0) continue;
                ReportStack.report(result, "Deletion of ContentFilteredTopic contained in DomainParticipant failed.");
                if (endResult != 0) continue;
                endResult = result;
            }
            Iterator<TopicImpl> it = this.topics.iterator();
            while (it.hasNext()) {
                result = it.next().deinit();
                if (result == 0 || result == 9) {
                    it.remove();
                }
                if (result == 0) continue;
                ReportStack.report(result, "Deletion of Topic contained in DomainParticipant failed.");
                if (endResult != 0) continue;
                endResult = result;
            }
        }
        ReportStack.flush(this, endResult != 0);
        return endResult;
    }

    @Override
    public int set_qos(DomainParticipantQos qos) {
        int result = 0;
        ListenerDispatcher dispatcher = null;
        SchedulingQosPolicyHolder scheduling_policy = new SchedulingQosPolicyHolder();
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == PARTICIPANT_QOS_DEFAULT.value) {
            DomainParticipantFactory factory = DomainParticipantFactory.get_instance();
            DomainParticipantQosHolder holder = new DomainParticipantQosHolder();
            factory.get_default_participant_qos(holder);
            qos = holder.value;
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            long uParticipant = this.get_user_object();
            if (uParticipant != 0L) {
                dispatcher = this.get_dispatcher();
                result = dispatcher.get_scheduling(scheduling_policy);
                if (result == 0 && (result = dispatcher.set_scheduling(qos.listener_scheduling)) == 0 && (result = this.jniSetQos(uParticipant, qos)) != 0) {
                    dispatcher.set_scheduling(scheduling_policy.value);
                }
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_qos(DomainParticipantQosHolder qos) {
        int result = 0;
        long uParticipant = 0L;
        ListenerDispatcher dispatcher = null;
        SchedulingQosPolicyHolder scheduling_policy = new SchedulingQosPolicyHolder();
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            uParticipant = this.get_user_object();
            if (uParticipant != 0L) {
                dispatcher = this.get_dispatcher();
                result = dispatcher.get_scheduling(scheduling_policy);
                if (result == 0 && (result = this.jniGetQos(uParticipant, qos)) == 0) {
                    qos.value.listener_scheduling = scheduling_policy.value;
                }
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int set_listener(DomainParticipantListener a_listener, int mask) {
        long uParticipant = 0L;
        int result = 0;
        ReportStack.start();
        DomainParticipantImpl domainParticipantImpl = this;
        synchronized (domainParticipantImpl) {
            uParticipant = this.get_user_object();
            if (uParticipant != 0L) {
                this.listener = a_listener;
                result = this.set_listener_interest(mask);
                if (result == 0) {
                    this.listenerInterest = mask & 0x80000001;
                    for (TopicImpl topic : this.topics) {
                        topic.set_participant_listener_mask(this.listenerInterest);
                    }
                }
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public DomainParticipantListener get_listener() {
        return this.listener;
    }

    @Override
    public int ignore_participant(long handle) {
        long uParticipant = 0L;
        int result = 0;
        ReportStack.start();
        uParticipant = this.get_user_object();
        result = uParticipant != 0L ? this.jniIgnoreParticipant(uParticipant, handle) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int ignore_topic(long handle) {
        long uParticipant = 0L;
        int result = 9;
        ReportStack.start();
        uParticipant = this.get_user_object();
        result = uParticipant != 0L ? this.jniIgnoreTopic(uParticipant, handle) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int ignore_publication(long handle) {
        long uParticipant = 0L;
        int result = 0;
        ReportStack.start();
        uParticipant = this.get_user_object();
        result = uParticipant != 0L ? this.jniIgnorePublication(uParticipant, handle) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int ignore_subscription(long handle) {
        long uParticipant = 0L;
        int result = 0;
        ReportStack.start();
        uParticipant = this.get_user_object();
        result = uParticipant != 0L ? this.jniIgnoreSubscription(uParticipant, handle) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_domain_id() {
        long uParticipant = 0L;
        int result = -1;
        ReportStack.start();
        uParticipant = this.get_user_object();
        if (uParticipant != 0L) {
            result = this.jniGetDomainId(uParticipant);
        }
        ReportStack.flush(this, result == -1);
        return result;
    }

    @Override
    public int assert_liveliness() {
        long uParticipant = 0L;
        int result = 0;
        ReportStack.start();
        uParticipant = this.get_user_object();
        result = uParticipant != 0L ? this.jniAssertLiveliness(uParticipant) : 9;
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int set_default_publisher_qos(PublisherQos qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == PUBLISHER_QOS_DEFAULT.value) {
            qos = Utilities.defaultPublisherQos;
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            this.defaultPublisherQos = Utilities.deepCopy(qos);
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_default_publisher_qos(PublisherQosHolder qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            qos.value = Utilities.deepCopy(this.defaultPublisherQos);
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int set_default_subscriber_qos(SubscriberQos qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else if (qos == SUBSCRIBER_QOS_DEFAULT.value) {
            qos = Utilities.defaultSubscriberQos;
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            this.defaultSubscriberQos = Utilities.deepCopy(qos);
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_default_subscriber_qos(SubscriberQosHolder qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            qos.value = Utilities.deepCopy(this.defaultSubscriberQos);
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int set_default_topic_qos(TopicQos qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
        } else if (qos == TOPIC_QOS_DEFAULT.value) {
            qos = Utilities.defaultTopicQos;
        } else {
            result = Utilities.checkQos(qos);
        }
        if (result == 0) {
            this.defaultTopicQos = Utilities.deepCopy(qos);
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_default_topic_qos(TopicQosHolder qos) {
        int result = 0;
        ReportStack.start();
        if (qos == null) {
            result = 3;
            ReportStack.report(result, "qos 'null' is invalid.");
        } else {
            qos.value = Utilities.deepCopy(this.defaultTopicQos);
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_discovered_participants(InstanceHandleSeqHolder participant_handles) {
        int result = 0;
        ReportStack.start();
        Subscriber sub = this.get_builtin_subscriber();
        if (sub != null) {
            DataReaderImpl dr = (DataReaderImpl)sub.lookup_datareader("DCPSParticipant");
            if (dr != null) {
                result = dr.read_instance_handles(participant_handles);
            } else {
                result = 4;
                ReportStack.report(result, "Could not resolve builtin DataReader for Topic 'DCPSParticipant'.");
            }
        } else {
            result = 4;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_discovered_participant_data(ParticipantBuiltinTopicDataHolder participant_data, long handle) {
        ParticipantBuiltinTopicDataSeqHolder dataList = null;
        SampleInfoSeqHolder infoList = null;
        int result = 0;
        ReportStack.start();
        Subscriber sub = this.get_builtin_subscriber();
        if (sub != null) {
            ParticipantBuiltinTopicDataDataReaderImpl dr = (ParticipantBuiltinTopicDataDataReaderImpl)sub.lookup_datareader("DCPSParticipant");
            if (dr != null) {
                dataList = new ParticipantBuiltinTopicDataSeqHolder();
                infoList = new SampleInfoSeqHolder();
                result = dr.read_instance(dataList, infoList, 1, handle, 65535, 65535, 65535);
                if (result == 0 && dataList.value.length == 1) {
                    participant_data.value = dataList.value[0];
                }
            } else {
                result = 4;
                ReportStack.report(result, "Could not resolve builtin DataReader for Topic 'DCPSParticipant'.");
            }
        } else {
            result = 4;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_discovered_topics(InstanceHandleSeqHolder topic_handles) {
        int result = 0;
        ReportStack.start();
        Subscriber sub = this.get_builtin_subscriber();
        if (sub != null) {
            DataReaderImpl dr = (DataReaderImpl)sub.lookup_datareader("DCPSTopic");
            if (dr != null) {
                result = dr.read_instance_handles(topic_handles);
            } else {
                result = 4;
                ReportStack.report(result, "Could not resolve builtin DataReader for Topic 'DCPSTopic'.");
            }
        } else {
            result = 4;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_discovered_topic_data(TopicBuiltinTopicDataHolder topic_data, long handle) {
        TopicBuiltinTopicDataSeqHolder dataList = null;
        SampleInfoSeqHolder infoList = null;
        int result = 0;
        ReportStack.start();
        Subscriber sub = this.get_builtin_subscriber();
        if (sub != null) {
            TopicBuiltinTopicDataDataReaderImpl dr = (TopicBuiltinTopicDataDataReaderImpl)sub.lookup_datareader("DCPSTopic");
            if (dr != null) {
                dataList = new TopicBuiltinTopicDataSeqHolder();
                infoList = new SampleInfoSeqHolder();
                result = dr.read_instance(dataList, infoList, 1, handle, 65535, 65535, 65535);
                if (result == 0 && dataList.value.length == 1) {
                    topic_data.value = dataList.value[0];
                }
            } else {
                result = 4;
                ReportStack.report(result, "Could not resolve builtin DataReader for Topic 'DCPSTopic'.");
            }
        } else {
            result = 4;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains_entity(long a_handle) {
        boolean found = false;
        DomainParticipantImpl domainParticipantImpl = this;
        synchronized (domainParticipantImpl) {
            long handle;
            Iterator<TopicImpl> it = this.topics.iterator();
            while (it.hasNext() && !found) {
                handle = it.next().get_instance_handle();
                found = handle == a_handle;
            }
            Iterator<PublisherImpl> ip = this.publishers.iterator();
            while (ip.hasNext() && !found) {
                PublisherImpl p = ip.next();
                handle = p.get_instance_handle();
                if (handle == a_handle) {
                    found = true;
                    continue;
                }
                found = p.contains_entity(a_handle);
            }
            Iterator<SubscriberImpl> is = this.subscribers.iterator();
            while (is.hasNext() && !found) {
                SubscriberImpl s = is.next();
                handle = s.get_instance_handle();
                if (handle == a_handle) {
                    found = true;
                    continue;
                }
                found = s.contains_entity(a_handle);
            }
            if (!found && this.builtinSubscriber != null) {
                if (this.builtinSubscriber.get_instance_handle() == a_handle) {
                    found = true;
                } else if (this.builtinSubscriber.contains_entity(a_handle)) {
                    found = true;
                }
            }
        }
        return found;
    }

    @Override
    public int get_current_time(Time_tHolder current_time) {
        long uParticipant = 0L;
        int result = 3;
        ReportStack.start();
        if (current_time == null) {
            result = 3;
            ReportStack.report(result, "current_time 'null' is invalid.");
        } else {
            uParticipant = this.get_user_object();
            result = uParticipant != 0L ? this.jniGetCurrentTime(uParticipant, current_time) : 9;
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    void setParticipantDataCopyCache(long copyCache) {
        this.participantDataCopyCache = copyCache;
    }

    void setTopicBuiltinTopicDataCopyCache(long copyCache) {
        this.topicBuiltinTopicDataCopyCache = copyCache;
    }

    @Override
    protected int notify(Event e) {
        int result = 0;
        DomainParticipantListener dpl = this.listener;
        ExtDomainParticipantListener edpl = null;
        if (dpl == null) {
            return result;
        }
        switch (e.kind) {
            case 512: {
                dpl.on_data_on_readers((Subscriber)((Object)e.observable));
                break;
            }
            case 1024: {
                dpl.on_data_available((DataReader)((Object)e.observable));
                break;
            }
            case 4: {
                dpl.on_requested_deadline_missed((DataReader)((Object)e.observable), (RequestedDeadlineMissedStatus)e.status);
                break;
            }
            case 64: {
                dpl.on_requested_incompatible_qos((DataReader)((Object)e.observable), (RequestedIncompatibleQosStatus)e.status);
                break;
            }
            case 256: {
                dpl.on_sample_rejected((DataReader)((Object)e.observable), (SampleRejectedStatus)e.status);
                break;
            }
            case 4096: {
                dpl.on_liveliness_changed((DataReader)((Object)e.observable), (LivelinessChangedStatus)e.status);
                break;
            }
            case 16384: {
                dpl.on_subscription_matched((DataReader)((Object)e.observable), (SubscriptionMatchedStatus)e.status);
                break;
            }
            case 128: {
                dpl.on_sample_lost((DataReader)((Object)e.observable), (SampleLostStatus)e.status);
                break;
            }
            case -2147483648: {
                edpl = (ExtDomainParticipantListener)this.listener;
                edpl.on_all_data_disposed((Topic)((Object)e.observable));
                break;
            }
            case 1: {
                edpl = (ExtDomainParticipantListener)this.listener;
                edpl.on_inconsistent_topic((Topic)((Object)e.observable), (InconsistentTopicStatus)e.status);
                break;
            }
            case 2: {
                dpl.on_offered_deadline_missed((DataWriter)((Object)e.observable), (OfferedDeadlineMissedStatus)e.status);
                break;
            }
            case 32: {
                dpl.on_offered_incompatible_qos((DataWriter)((Object)e.observable), (OfferedIncompatibleQosStatus)e.status);
                break;
            }
            case 2048: {
                dpl.on_liveliness_lost((DataWriter)((Object)e.observable), (LivelinessLostStatus)e.status);
                break;
            }
            case 8192: {
                dpl.on_publication_matched((DataWriter)((Object)e.observable), (PublicationMatchedStatus)e.status);
                break;
            }
            default: {
                ReportStack.report(2, "Received unsupported event kind '" + e.kind + "'.");
            }
        }
        return result;
    }

    protected Map<String, TypeSupportImpl> get_typesupports() {
        return this.typeSupports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int register_type(TypeSupportImpl typeSupport, String type_alias) {
        int result = 3;
        ReportStack.start();
        DomainParticipantImpl domainParticipantImpl = this;
        synchronized (domainParticipantImpl) {
            long uParticipant = this.get_user_object();
            if (uParticipant != 0L) {
                boolean res = this.add(typeSupport, type_alias);
                if (!res) {
                    TypeSupportImpl ts = this.lookup_typeSupport(type_alias);
                    result = ts != typeSupport ? (ts.get_type_name() != null && ts.get_key_list() != null ? (!ts.get_type_name().equals(typeSupport.get_type_name()) || !ts.get_key_list().equals(typeSupport.get_key_list()) ? 4 : 0) : 1) : 0;
                } else {
                    result = this.jniRegisterType(uParticipant, type_alias, typeSupport.get_descriptor(), typeSupport.get_data_representation_id(), typeSupport.get_type_hash(), typeSupport.get_meta_data(), typeSupport.get_extentions());
                    if (result == 0) {
                        long jniCopyCache = this.jniCopyCacheNew(uParticipant, typeSupport.get_type_name(), type_alias, typeSupport.get_package_redirects());
                        typeSupport.set_copyCache(jniCopyCache);
                        if (jniCopyCache == 0L) {
                            this.remove(type_alias);
                        }
                    } else {
                        ReportStack.report(result, "Register type failed for type:" + typeSupport.get_type_name() + ".");
                    }
                }
            } else {
                result = 9;
            }
        }
        ReportStack.flush(result != 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete_historical_data(String partition_expression, String topic_expression) {
        int result = 0;
        long uParticipant = 0L;
        ReportStack.start();
        if (partition_expression == null) {
            result = 3;
            ReportStack.report(result, "partition_expression 'null' is invalid.");
        } else if (topic_expression == null) {
            result = 3;
            ReportStack.report(result, "topic_expression 'null' is invalid.");
        }
        if (result == 0) {
            DomainParticipantImpl domainParticipantImpl = this;
            synchronized (domainParticipantImpl) {
                uParticipant = this.get_user_object();
                if (uParticipant != 0L) {
                    result = this.jniDeleteHistoricalData(uParticipant, partition_expression, topic_expression);
                    if (result != 0) {
                        ReportStack.report(result, "Could not delete historical data.");
                    }
                } else {
                    result = 1;
                    ReportStack.report(result, "Could not delete historical data invalid participant.");
                }
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int set_property(Property a_property) {
        int result = 0;
        ReportStack.start();
        result = this.checkProperty(a_property);
        if (result == 0) {
            long uParticipant = this.get_user_object();
            if (uParticipant != 0L) {
                a_property.name = a_property.name.toLowerCase();
                a_property.value = a_property.value.toLowerCase();
                result = this.jniSetProperty(uParticipant, a_property);
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    @Override
    public int get_property(PropertyHolder a_property) {
        int result = 0;
        ReportStack.start();
        result = this.checkPropertyHolder(a_property);
        if (result == 0) {
            long uParticipant = this.get_user_object();
            if (uParticipant != 0L) {
                a_property.value.name = a_property.value.name.toLowerCase();
                result = this.jniGetProperty(uParticipant, a_property);
            } else {
                result = 9;
            }
        }
        ReportStack.flush(this, result != 0);
        return result;
    }

    private native long jniDomainParticipantNew(String var1, int var2, DomainParticipantQos var3);

    private native int jniDomainParticipantFree(long var1);

    private native long jniFindTopic(long var1, String var3, Duration_t var4);

    private native int jniSetQos(long var1, DomainParticipantQos var3);

    private native int jniGetQos(long var1, DomainParticipantQosHolder var3);

    private native int jniIgnoreParticipant(long var1, long var3);

    private native int jniIgnoreTopic(long var1, long var3);

    private native int jniIgnorePublication(long var1, long var3);

    private native int jniIgnoreSubscription(long var1, long var3);

    private native int jniGetDomainId(long var1);

    private native int jniAssertLiveliness(long var1);

    private native int jniGetCurrentTime(long var1, Time_tHolder var3);

    private native int jniRegisterType(long var1, String var3, String var4, short var5, byte[] var6, byte[] var7, byte[] var8);

    private native int jniDeleteHistoricalData(long var1, String var3, String var4);

    private native long jniCopyCacheNew(long var1, String var3, String var4, String var5);

    private native int jniSetProperty(long var1, Property var3);

    private native int jniGetProperty(long var1, PropertyHolder var3);
}

