/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server.jwt;

import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.lsst.ccs.web.rest.file.server.jwt.JWTTokenNeeded;

@Provider
@JWTTokenNeeded
@Priority(value=1000)
public class JWTTokenNeededFilter
implements ContainerRequestFilter {
    @Context
    private HttpServletRequest httpServletRequest;
    private static final String allowedIPs = System.getenv("CCS_REST_ALLOWED_IPS");
    private static final Pattern ALLOWED_IPS_PATTERN = allowedIPs == null ? null : Pattern.compile(allowedIPs);
    private static final Logger LOG = Logger.getLogger(JWTTokenNeededFilter.class.getName());

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String authorizationHeader;
        if (ALLOWED_IPS_PATTERN != null) {
            String[] ipChain;
            String remoteIp = this.httpServletRequest.getRemoteAddr();
            String forwardedFor = this.httpServletRequest.getHeader("X-FORWARDED-FOR");
            if (forwardedFor != null && (ipChain = forwardedFor.split(",")).length > 0) {
                remoteIp = ipChain[0].trim();
            }
            if (ALLOWED_IPS_PATTERN.matcher(remoteIp).matches()) {
                return;
            }
            LOG.log(Level.INFO, "Remote IP {0} could not be allowed against {1}", new Object[]{remoteIp, allowedIPs});
        }
        if ((authorizationHeader = requestContext.getHeaderString("Authorization")) == null) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        } else {
            String token = authorizationHeader.substring("Bearer".length()).trim();
            try {
                System.out.println("Got token " + token);
                System.out.println(" from " + this.httpServletRequest.getRemoteAddr());
                FirebaseToken decodedToken = FirebaseAuth.getInstance().verifyIdToken(token);
                String uid = decodedToken.getUid();
                System.out.println("Got uid " + uid);
            }
            catch (FirebaseAuthException e) {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        }
    }
}

