/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
public class VersionedFile {
    private static final Set<PosixFilePermission> READ_ONLY = PosixFilePermissions.fromString("r--r--r--");
    private static final String LATEST = "latest";
    private static final String DEFAULT = "default";
    private static final String USER_VERSIONED_FILE = "user.isVersionedFile";
    private static final String META_FILE_NAME = "version-meta.properties";
    private static final String HIDDEN_VERSIONS_PROPERTY = "hidden-versions";
    private static final String COMMENT_PROPERTY = "comment.";
    private final Properties meta;
    private final Path path;

    VersionedFile(Path path) throws IOException {
        this.path = path;
        if (!VersionedFile.isVersionedFile((Path)path)) {
            throw new IOException("Not a versioned file: " + path);
        }
        this.meta = VersionedFile.loadMetaFile((Path)path);
    }

    static boolean isVersionedFile(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        boolean hasMetaFile = Files.exists(path.resolve("version-meta.properties"), new LinkOption[0]);
        UserDefinedFileAttributeView view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
        if (!view.list().contains("user.isVersionedFile") && !hasMetaFile) {
            return false;
        }
        if (!Files.isSymbolicLink(path.resolve("latest")) || !Files.isSymbolicLink(path.resolve("default"))) {
            return false;
        }
        if (!hasMetaFile) {
            VersionedFile.createMetaFile((Path)path);
        }
        return true;
    }

    int[] getVersions() throws IOException {
        return this.getVersions(true);
    }

    int[] getVersions(boolean includeHidden) throws IOException {
        try (Stream<Path> list = Files.list(this.path);){
            int[] nArray = list.filter(p -> !Files.isSymbolicLink(p)).map(p -> p.getFileName().toString()).filter(s -> s.matches("\\d+")).mapToInt(s -> Integer.parseInt(s)).filter(v -> includeHidden || !this.isHidden(v)).sorted().toArray();
            return nArray;
        }
    }

    int getLatestVersion() throws IOException {
        return Integer.parseInt(this.path.resolve("latest").toRealPath(new LinkOption[0]).getFileName().toString());
    }

    int getDefaultVersion() throws IOException {
        return Integer.parseInt(this.path.resolve("default").toRealPath(new LinkOption[0]).getFileName().toString());
    }

    void setDefaultVersion(int version) throws IOException {
        Path targetPath = this.path.resolve(String.valueOf(version));
        if (version < 1 || !Files.exists(targetPath, new LinkOption[0])) {
            throw new IOException("Invalid version " + version);
        }
        Files.deleteIfExists(this.path.resolve("default"));
        Files.createSymbolicLink(this.path.resolve("default"), this.path.relativize(targetPath), new FileAttribute[0]);
    }

    Path getPathForVersion(int version) throws IOException {
        Path targetPath = this.path.resolve(String.valueOf(version));
        if (!Files.exists(this.path, new LinkOption[0])) {
            throw new IOException("Invalid version " + version);
        }
        return targetPath;
    }

    Path getDefault() {
        return this.path.resolve("default");
    }

    Path getLatest() {
        return this.path.resolve("latest");
    }

    private Set<Integer> getHiddenVersions() {
        String hiddenVersionsString = this.meta.getProperty("hidden-versions", "");
        if (hiddenVersionsString.isEmpty()) {
            return new TreeSet<Integer>();
        }
        return Arrays.stream(hiddenVersionsString.trim().split("\\s*,\\s*")).map(s -> Integer.valueOf(s)).collect(Collectors.toCollection(TreeSet::new));
    }

    boolean isHidden(int version) {
        return this.getHiddenVersions().contains(version);
    }

    void setHidden(int version, boolean isHidden) throws IOException {
        boolean modified;
        Set hiddenVersions = this.getHiddenVersions();
        if (isHidden) {
            if (version == this.getLatestVersion()) {
                throw new RuntimeException("Latest version cannot be hidden");
            }
            if (version == this.getDefaultVersion()) {
                throw new RuntimeException("Default version cannot be hidden");
            }
            modified = hiddenVersions.add(version);
        } else {
            modified = hiddenVersions.remove(version);
        }
        if (modified) {
            this.meta.setProperty("hidden-versions", hiddenVersions.stream().map(String::valueOf).collect(Collectors.joining(",")));
            VersionedFile.updateMetaFile((Path)this.path, (Properties)this.meta);
        }
    }

    String getComment(int version) {
        return this.meta.getProperty("comment." + version, "");
    }

    void setComment(int version, String comment) throws IOException {
        this.meta.setProperty("comment." + version, comment);
        VersionedFile.updateMetaFile((Path)this.path, (Properties)this.meta);
    }

    int addVersion(byte[] content, boolean onlyIfChanged) throws IOException {
        byte[] previousData;
        int version = this.getLatestVersion() + 1;
        if (version > 1 && onlyIfChanged && Arrays.equals(previousData = Files.readAllBytes(this.getLatest()), content)) {
            return this.getLatestVersion();
        }
        Path file = this.path.resolve(String.valueOf(version));
        Files.write(file, content, new OpenOption[0]);
        Files.setPosixFilePermissions(file, READ_ONLY);
        Files.deleteIfExists(this.path.resolve("latest"));
        Files.createSymbolicLink(this.path.resolve("latest"), this.path.relativize(file), new FileAttribute[0]);
        return version;
    }

    static VersionedFile create(Path path, byte[] content) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            throw new IOException("File already exists: " + path);
        }
        Path dir = Files.createDirectory(path, new FileAttribute[0]);
        UserDefinedFileAttributeView view = Files.getFileAttributeView(dir, UserDefinedFileAttributeView.class, new LinkOption[0]);
        view.write("user.isVersionedFile", Charset.defaultCharset().encode("true"));
        Path file = dir.resolve("1");
        Files.write(file, content, new OpenOption[0]);
        Files.setPosixFilePermissions(file, READ_ONLY);
        Files.createSymbolicLink(dir.resolve("latest"), dir.relativize(file), new FileAttribute[0]);
        Files.createSymbolicLink(dir.resolve("default"), dir.relativize(file), new FileAttribute[0]);
        VersionedFile.createMetaFile((Path)dir);
        return new VersionedFile(dir);
    }

    private static void createMetaFile(Path dir) throws IOException {
        Properties meta = new Properties();
        VersionedFile.updateMetaFile((Path)dir, (Properties)meta);
    }

    private static void updateMetaFile(Path dir, Properties props) throws IOException {
        try (OutputStream out = Files.newOutputStream(dir.resolve("version-meta.properties"), new OpenOption[0]);){
            props.store(out, null);
        }
    }

    static Properties loadMetaFile(Path dir) throws IOException {
        try (InputStream in = Files.newInputStream(dir.resolve("version-meta.properties"), new OpenOption[0]);){
            Properties meta = new Properties();
            meta.load(in);
            Properties properties = meta;
            return properties;
        }
    }

    static VersionedFile convert(Path unversionedFile) throws IOException {
        if (!Files.exists(unversionedFile, new LinkOption[0])) {
            throw new NoSuchFileException("File not found " + unversionedFile);
        }
        if (VersionedFile.isVersionedFile((Path)unversionedFile)) {
            throw new IOException("File is already versioned: " + unversionedFile);
        }
        Path tempName = unversionedFile.resolveSibling(unversionedFile.getFileName() + "$$TMP$$");
        Path dir = Files.createDirectory(tempName, new FileAttribute[0]);
        UserDefinedFileAttributeView view = Files.getFileAttributeView(dir, UserDefinedFileAttributeView.class, new LinkOption[0]);
        view.write("user.isVersionedFile", Charset.defaultCharset().encode("true"));
        Path newFileName = tempName.resolve("1");
        Files.move(unversionedFile, newFileName, new CopyOption[0]);
        Files.setPosixFilePermissions(newFileName, READ_ONLY);
        Files.createSymbolicLink(dir.resolve("latest"), dir.relativize(newFileName), new FileAttribute[0]);
        Files.createSymbolicLink(dir.resolve("default"), dir.relativize(newFileName), new FileAttribute[0]);
        VersionedFile.createMetaFile((Path)dir);
        Files.move(dir, unversionedFile, new CopyOption[0]);
        return new VersionedFile(unversionedFile);
    }

    String getFileName() {
        return this.path.getFileName().toString();
    }

    void delete() throws IOException {
        Files.walk(this.path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }
}

